/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public final class BinanceOrderbook {
    public final long lastUpdateId;
    public final SortedMap<BigDecimal, BigDecimal> bids;
    public final SortedMap<BigDecimal, BigDecimal> asks;

    public BinanceOrderbook(@JsonProperty(value="lastUpdateId") long lastUpdateId, @JsonProperty(value="bids") List<Object[]> bidsJson, @JsonProperty(value="asks") List<Object[]> asksJson) {
        this.lastUpdateId = lastUpdateId;
        BiConsumer<Object[], Map> entryProcessor = (obj, col) -> {
            BigDecimal price = new BigDecimal(obj[0].toString());
            BigDecimal qty = new BigDecimal(obj[1].toString());
            col.put(price, qty);
        };
        TreeMap bids = new TreeMap((k1, k2) -> -k1.compareTo((BigDecimal)k2));
        TreeMap asks = new TreeMap();
        bidsJson.stream().forEach(e -> entryProcessor.accept((Object[])e, bids));
        asksJson.stream().forEach(e -> entryProcessor.accept((Object[])e, asks));
        this.bids = Collections.unmodifiableSortedMap(bids);
        this.asks = Collections.unmodifiableSortedMap(asks);
    }
}

