/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu.serialization.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import si.mazi.rescu.ResponseReader;

public class JacksonResponseReader
extends ResponseReader {
    private final ObjectMapper objectMapper;

    public JacksonResponseReader(ObjectMapper objectMapper, boolean ignoreHttpErrorCodes) {
        super(ignoreHttpErrorCodes);
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T read(String httpBody, Type returnType) throws IOException {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(returnType);
        return (T)this.objectMapper.readValue(httpBody, javaType);
    }

    @Override
    protected RuntimeException readException(String httpBody, Class<? extends RuntimeException> exceptionType) throws IOException {
        return (RuntimeException)this.read(httpBody, exceptionType);
    }
}

