/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.AnnotationUtils;
import si.mazi.rescu.HttpMethod;
import si.mazi.rescu.Params;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RequestWriter;
import si.mazi.rescu.RequestWriterResolver;
import si.mazi.rescu.RestMethodMetadata;

public class RestInvocation
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RestInvocation.class);
    protected static final List<Class<? extends Annotation>> PARAM_ANNOTATION_CLASSES = Arrays.asList(QueryParam.class, PathParam.class, FormParam.class, HeaderParam.class);
    private static final Pattern STARTS_WITH_SLASHES = Pattern.compile("(/*)(.*)");
    private static final Pattern ENDS_WITH_SLASHES = Pattern.compile("(.*?)(/*)");
    private final Map<Class<? extends Annotation>, Params> paramsMap;
    private final List<Object> unannanotatedParams;
    private final RestMethodMetadata methodMetadata;
    private final String methodPath;
    private final String invocationUrl;
    private final String queryString;
    private final String path;
    private final RequestWriter requestWriter;
    private Map<String, String> allHttpHeaders;

    RestInvocation(Map<Class<? extends Annotation>, Params> paramsMap, List<Object> unannanotatedParams, RestMethodMetadata methodMetadata, String methodPath, String path, RequestWriterResolver requestWriterResolver) {
        this.paramsMap = paramsMap;
        this.unannanotatedParams = unannanotatedParams;
        this.methodMetadata = methodMetadata;
        this.methodPath = methodPath;
        this.path = path;
        this.requestWriter = requestWriterResolver == null ? null : requestWriterResolver.resolveWriter(this.getMethodMetadata());
        this.paramsMap.get(QueryParam.class).digestAll(this);
        this.queryString = paramsMap.get(QueryParam.class).asQueryString();
        this.invocationUrl = RestInvocation.getInvocationUrl(methodMetadata.getBaseUrl(), path, this.queryString);
        for (int i = 0; i < this.unannanotatedParams.size(); ++i) {
            Object param = this.unannanotatedParams.get(i);
            if (!(param instanceof ParamsDigest)) continue;
            this.unannanotatedParams.set(i, ((ParamsDigest)param).digestParams(this));
        }
        this.paramsMap.keySet().stream().filter(par -> !QueryParam.class.equals(par)).map(this.paramsMap::get).forEach(params -> params.digestAll(this));
    }

    public static RestInvocation create(RequestWriterResolver requestWriterResolver, RestMethodMetadata methodMetadata, Object[] args, Map<Class<? extends Annotation>, Params> defaultParamsMap) {
        HashMap<Class<? extends Annotation>, Params> paramsMap = RestInvocation.createEmptyParamsMap(defaultParamsMap);
        ArrayList<Object> unannanotatedParams = new ArrayList<Object>();
        Annotation[][] paramAnnotations = methodMetadata.getParameterAnnotations();
        for (int i = 0; i < paramAnnotations.length; ++i) {
            Annotation[] paramAnns = paramAnnotations[i];
            if (paramAnns.length == 0) {
                unannanotatedParams.add(args[i]);
            }
            for (Object object : paramAnns) {
                String paramName = RestInvocation.getParamName((Annotation)object);
                if (paramName == null) continue;
                paramsMap.get(object.annotationType()).add(paramName, args[i]);
            }
        }
        Map<Class<? extends Annotation>, Annotation> methodAnnotationMap = methodMetadata.getMethodAnnotationMap();
        for (Class clazz : methodAnnotationMap.keySet()) {
            Annotation annotation = methodAnnotationMap.get(clazz);
            if (annotation == null) continue;
            String paramName = RestInvocation.getParamName(annotation);
            paramsMap.get(clazz).add(paramName, methodMetadata.getMethodName());
        }
        for (Params params : paramsMap.values()) {
            params.replaceValueFactories();
        }
        String methodPath = RestInvocation.getPath(paramsMap, methodMetadata.getMethodPathTemplate());
        String string2 = RestInvocation.getPath(paramsMap, methodMetadata.getIntfacePath());
        string2 = RestInvocation.appendPath(string2, methodPath);
        RestInvocation invocation = new RestInvocation(paramsMap, unannanotatedParams, methodMetadata, methodPath, string2, requestWriterResolver);
        if (!unannanotatedParams.isEmpty() && Arrays.asList(HttpMethod.DELETE, HttpMethod.GET).contains((Object)methodMetadata.getHttpMethod())) {
            log.warn("{} request will contain a body. While this is allowed, the body should be ignored by the server. Is this intended? Method: {}", (Object)methodMetadata.getHttpMethod(), (Object)methodMetadata.getMethodName());
        }
        return invocation;
    }

    public static HashMap<Class<? extends Annotation>, Params> createEmptyParamsMap(Map<Class<? extends Annotation>, Params> defaultParamsMap) {
        HashMap<Class<? extends Annotation>, Params> paramsMap = new HashMap<Class<? extends Annotation>, Params>();
        for (Class<? extends Annotation> annotationClass : PARAM_ANNOTATION_CLASSES) {
            paramsMap.put(annotationClass, Params.of());
        }
        if (defaultParamsMap != null) {
            defaultParamsMap.keySet().forEach(h -> paramsMap.put((Class<? extends Annotation>)h, ((Params)defaultParamsMap.get(h)).copy()));
        }
        return paramsMap;
    }

    private static String getParamName(Annotation queryParam) {
        for (Class<? extends Annotation> annotationClass : PARAM_ANNOTATION_CLASSES) {
            String paramName = AnnotationUtils.getValueOrNull(annotationClass, queryParam);
            if (paramName == null) continue;
            return paramName;
        }
        return null;
    }

    static String getInvocationUrl(String baseUrl, String apiPath, String queryString) {
        String completeUrl = baseUrl;
        completeUrl = RestInvocation.appendPath(completeUrl, apiPath);
        completeUrl = RestInvocation.appendIfNotEmpty(completeUrl, queryString, "?");
        return completeUrl;
    }

    static String appendIfNotEmpty(String url, String next, String separator) {
        if (next != null && RestInvocation.isNonEmpty(next)) {
            if (!url.endsWith(separator) && !next.startsWith(separator)) {
                url = url + separator;
            }
            url = url + next;
        }
        return url;
    }

    static String appendPath(String first, String second) {
        first = RestInvocation.nullToEmpty(first);
        second = RestInvocation.nullToEmpty(second);
        Matcher firstParsed = ENDS_WITH_SLASHES.matcher(first);
        if (!firstParsed.matches()) {
            throw new RuntimeException("Incorrect regular expression ENDS_WITH_SLASHES, fix the bug in rescu.");
        }
        Matcher secondParsed = STARTS_WITH_SLASHES.matcher(second);
        if (!secondParsed.matches()) {
            throw new RuntimeException("Incorrect regular expression STARTS_WITH_SLASHES, fix the bug in rescu.");
        }
        String firstTrimmed = firstParsed.group(1);
        String secondTrimmed = secondParsed.group(2);
        boolean midSlash = RestInvocation.isNonEmpty(firstParsed.group(2)) || RestInvocation.isNonEmpty(secondParsed.group(1)) || RestInvocation.isNonEmpty(firstTrimmed) && RestInvocation.isNonEmpty(secondTrimmed);
        return firstTrimmed + (midSlash ? "/" : "") + secondTrimmed;
    }

    private static boolean isNonEmpty(String str) {
        return str.length() > 0;
    }

    private static String nullToEmpty(String str) {
        return str == null ? "" : str;
    }

    static String getPath(Map<Class<? extends Annotation>, Params> paramsMap, String methodPath) {
        return paramsMap.get(PathParam.class).applyToPath(methodPath);
    }

    public String getRequestBody() {
        return this.requestWriter.writeBody(this);
    }

    @Deprecated
    public Map<String, String> getAllHttpHeaders() {
        if (this.allHttpHeaders == null) {
            this.allHttpHeaders = new HashMap<String, String>();
            this.allHttpHeaders.putAll(this.getHttpHeadersFromParams());
            if (this.methodMetadata.getReqContentType() != null) {
                this.allHttpHeaders.put("Content-Type", this.methodMetadata.getReqContentType());
            }
            if (this.methodMetadata.getResContentType() != null) {
                this.allHttpHeaders.put("Accept", this.methodMetadata.getResContentType());
            }
        }
        return this.allHttpHeaders;
    }

    public Map<String, String> getHttpHeadersFromParams() {
        return this.getParamsMap().get(HeaderParam.class).asHttpHeaders();
    }

    public String getReqContentType() {
        return this.methodMetadata.getReqContentType();
    }

    public String getInvocationUrl() {
        return this.invocationUrl;
    }

    public String getMethodPath() {
        return this.methodPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getBaseUrl() {
        return this.getMethodMetadata().getBaseUrl();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getHttpMethod() {
        return this.getMethodMetadata().getHttpMethod().toString();
    }

    public RestMethodMetadata getMethodMetadata() {
        return this.methodMetadata;
    }

    public Object getParamValue(Class<? extends Annotation> paramAnnotation, String paramName) {
        if (!PARAM_ANNOTATION_CLASSES.contains(paramAnnotation)) {
            throw new IllegalArgumentException("Unsupported annotation type: " + paramAnnotation + ". Should be one of " + PARAM_ANNOTATION_CLASSES);
        }
        return this.getParamsMap().get(paramAnnotation).getParamValue(paramName);
    }

    public Map<Class<? extends Annotation>, Params> getParamsMap() {
        return this.paramsMap;
    }

    public List<Object> getUnannanotatedParams() {
        return this.unannanotatedParams;
    }
}

