/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceErrorAdapter;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.BinanceTradeHistoryParams;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import org.knowm.xchange.binance.dto.trade.TrailingFlag;
import org.knowm.xchange.binance.service.BinanceTradeServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.OpenPositions;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelAllOrders;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderByInstrument;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamInstrument;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsIdSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParam;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamInstrument;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamInstrument;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParamInstrument;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;
import org.knowm.xchange.utils.Assert;

public class BinanceTradeService
extends BinanceTradeServiceRaw
implements TradeService {
    public BinanceTradeService(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders((OpenOrdersParams)new DefaultOpenOrdersParam());
    }

    public OpenOrders getOpenOrders(CurrencyPair pair) throws IOException {
        return this.getOpenOrders((OpenOrdersParams)new DefaultOpenOrdersParamCurrencyPair(pair));
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        try {
            Instrument pair = null;
            if (params instanceof OpenOrdersParamInstrument) {
                pair = ((OpenOrdersParamInstrument)params).getInstrument();
            } else if (params instanceof OpenOrdersParamCurrencyPair) {
                pair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
            }
            return BinanceAdapters.adaptOpenOrders(this.openOrdersAllProducts(pair), pair instanceof FuturesContract);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String placeMarketOrder(MarketOrder mo) throws IOException {
        return this.placeOrderAllProducts(OrderType.MARKET, (Order)mo, null, null, null, null, null, null);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        OrderType type;
        TimeInForce tif = this.getOrderFlag((Order)limitOrder, TimeInForce.class).orElse(TimeInForce.GTC);
        if (limitOrder.hasFlag((Order.IOrderFlags)org.knowm.xchange.binance.dto.trade.BinanceOrderFlags.LIMIT_MAKER)) {
            type = OrderType.LIMIT_MAKER;
            tif = null;
        } else {
            type = OrderType.LIMIT;
        }
        return this.placeOrderAllProducts(type, (Order)limitOrder, limitOrder.getLimitPrice(), null, null, null, null, tif);
    }

    public String placeStopOrder(StopOrder order) throws IOException {
        TimeInForce tif = this.getOrderFlag((Order)order, TimeInForce.class).orElse(order.getLimitPrice() != null ? TimeInForce.GTC : null);
        Long trailingDelta = this.getOrderFlag((Order)order, TrailingFlag.class).map(TrailingFlag::getTrailingBip).orElse(null);
        OrderType orderType = BinanceAdapters.adaptOrderType(order);
        return this.placeOrderAllProducts(orderType, (Order)order, order.getLimitPrice(), order.getStopPrice(), null, trailingDelta, order.getTrailValue(), tif);
    }

    private <T extends Order.IOrderFlags> Optional<T> getOrderFlag(Order order, Class<T> clazz) {
        return order.getOrderFlags().stream().filter(flag -> clazz.isAssignableFrom(flag.getClass())).findFirst();
    }

    private String placeOrderAllProducts(OrderType type, Order order, BigDecimal limitPrice, BigDecimal stopPrice, BigDecimal quoteOrderQty, Long trailingDelta, BigDecimal callBackRate, TimeInForce tif) throws IOException {
        try {
            String orderId = order.getInstrument() instanceof FuturesContract ? (((BinanceExchange)this.exchange).isPortfolioMarginEnabled() ? (BinanceAdapters.isInverse(order.getInstrument()).booleanValue() ? this.newPortfolioMarginInverseFutureOrder(order.getInstrument(), BinanceAdapters.convert(order.getType()), type, tif, order.getOriginalAmount(), order.hasFlag((Order.IOrderFlags)org.knowm.xchange.binance.dto.trade.BinanceOrderFlags.REDUCE_ONLY), limitPrice, order.getUserReference(), null).getOrderId() : this.newPortfolioMarginFutureOrder(order.getInstrument(), BinanceAdapters.convert(order.getType()), type, tif, order.getOriginalAmount(), order.hasFlag((Order.IOrderFlags)org.knowm.xchange.binance.dto.trade.BinanceOrderFlags.REDUCE_ONLY), limitPrice, order.getUserReference(), null).getOrderId()) : (BinanceAdapters.isInverse(order.getInstrument()).booleanValue() ? this.newInverseFutureOrder(order.getInstrument(), BinanceAdapters.convert(order.getType()), type, tif, order.getOriginalAmount(), order.hasFlag((Order.IOrderFlags)org.knowm.xchange.binance.dto.trade.BinanceOrderFlags.REDUCE_ONLY), limitPrice, order.getUserReference(), stopPrice, false, null, callBackRate, null).getOrderId() : this.newFutureOrder(order.getInstrument(), BinanceAdapters.convert(order.getType()), type, tif, order.getOriginalAmount(), order.hasFlag((Order.IOrderFlags)org.knowm.xchange.binance.dto.trade.BinanceOrderFlags.REDUCE_ONLY), limitPrice, order.getUserReference(), stopPrice, false, null, callBackRate, null).getOrderId())) : Long.toString(this.newOrder((Instrument)order.getInstrument(), (OrderSide)BinanceAdapters.convert((Order.OrderType)order.getType()), (OrderType)type, (TimeInForce)tif, (BigDecimal)order.getOriginalAmount(), (BigDecimal)quoteOrderQty, (BigDecimal)limitPrice, (String)order.getUserReference(), (BigDecimal)stopPrice, (Long)trailingDelta, null, null).orderId);
            return orderId;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public void placeTestOrder(OrderType type, Order order, BigDecimal limitPrice, BigDecimal stopPrice) throws IOException {
        this.placeTestOrder(type, order, limitPrice, stopPrice, null, null);
    }

    public void placeTestOrder(OrderType type, Order order, BigDecimal limitPrice, BigDecimal stopPrice, BigDecimal quoteOrderQty, Long trailingDelta) throws IOException {
        try {
            TimeInForce tif = this.getOrderFlag(order, TimeInForce.class).orElse(null);
            this.testNewOrder(order.getInstrument(), BinanceAdapters.convert(order.getType()), type, tif, order.getOriginalAmount(), quoteOrderQty, limitPrice, order.getUserReference(), stopPrice, trailingDelta, null);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(CancelOrderParams params) throws IOException {
        try {
            if (!(params instanceof CancelOrderByInstrument) && !(params instanceof CancelOrderByIdParams)) {
                throw new ExchangeException("You need to provide the currency pair and the order id to cancel an order.");
            }
            assert (params instanceof CancelOrderByInstrument);
            CancelOrderByInstrument paramInstrument = (CancelOrderByInstrument)params;
            CancelOrderByIdParams paramId = (CancelOrderByIdParams)params;
            this.cancelOrderAllProducts(paramInstrument.getInstrument(), BinanceAdapters.id(paramId.getOrderId()), null, null);
            return true;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(String orderId) {
        throw new ExchangeException("You need to provide the currency pair to cancel an order.");
    }

    public Class[] getRequiredCancelOrderParamClasses() {
        return new Class[]{CancelOrderByIdParams.class, CancelOrderByInstrument.class};
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        try {
            Assert.isTrue((boolean)(params instanceof TradeHistoryParamInstrument), (String)"You need to provide the instrument to get the user trades.");
            TradeHistoryParamInstrument pairParams = (TradeHistoryParamInstrument)params;
            Instrument pair = pairParams.getInstrument();
            if (pair == null) {
                throw new ExchangeException("You need to provide the instrument to get the user trades.");
            }
            Long orderId = null;
            Long startTime = null;
            Long endTime = null;
            if (params instanceof TradeHistoryParamsTimeSpan) {
                if (((TradeHistoryParamsTimeSpan)params).getStartTime() != null) {
                    startTime = ((TradeHistoryParamsTimeSpan)params).getStartTime().getTime();
                }
                if (((TradeHistoryParamsTimeSpan)params).getEndTime() != null) {
                    endTime = ((TradeHistoryParamsTimeSpan)params).getEndTime().getTime();
                }
            }
            Long fromId = null;
            if (params instanceof TradeHistoryParamsIdSpan) {
                TradeHistoryParamsIdSpan idParams = (TradeHistoryParamsIdSpan)params;
                try {
                    fromId = BinanceAdapters.id(idParams.getStartId());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (fromId != null && (startTime != null || endTime != null)) {
                throw new ExchangeException("You should either specify the id from which you get the user trades from or start and end times. If you specify both, Binance will only honour the fromId parameter.");
            }
            Integer limit = null;
            if (params instanceof TradeHistoryParamLimit) {
                TradeHistoryParamLimit limitParams = (TradeHistoryParamLimit)params;
                limit = limitParams.getLimit();
            }
            List<BinanceTrade> binanceTrades = this.myTradesAllProducts(pair, orderId, startTime, endTime, fromId, limit);
            return BinanceAdapters.adaptUserTrades(binanceTrades, pair instanceof FuturesContract);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public Collection<Order> getOrder(OrderQueryParams ... params) throws IOException {
        try {
            ArrayList<Order> orders = new ArrayList<Order>();
            for (OrderQueryParams param : params) {
                if (!(param instanceof OrderQueryParamInstrument)) {
                    throw new ExchangeException("Parameters must be an instance of OrderQueryParamInstrument");
                }
                OrderQueryParamInstrument orderQueryParamInstrument = (OrderQueryParamInstrument)param;
                if (orderQueryParamInstrument.getInstrument() == null || orderQueryParamInstrument.getOrderId() == null) {
                    throw new ExchangeException("You need to provide the currency pair and the order id to query an order.");
                }
                orders.add(BinanceAdapters.adaptOrder(this.orderStatusAllProducts(orderQueryParamInstrument.getInstrument(), BinanceAdapters.id(orderQueryParamInstrument.getOrderId()), null), orderQueryParamInstrument.getInstrument() instanceof FuturesContract));
            }
            return orders;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public OpenPositions getOpenPositions() throws IOException {
        return new OpenPositions(BinanceAdapters.adaptOpenPositions(this.openPositions()));
    }

    public Collection<String> cancelAllOrders(CancelAllOrders orderParams) throws IOException {
        if (!(orderParams instanceof CancelOrderByInstrument)) {
            throw new NotAvailableFromExchangeException("Parameters must be an instance of " + CancelOrderByInstrument.class.getSimpleName());
        }
        Instrument instrument = ((CancelOrderByInstrument)orderParams).getInstrument();
        return this.cancelAllOpenOrdersAllProducts(instrument).stream().map(binanceCancelledOrder -> Long.toString(binanceCancelledOrder.orderId)).collect(Collectors.toList());
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new BinanceTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamInstrument();
    }

    public Collection<Order> getOrder(String ... orderIds) {
        throw new NotAvailableFromExchangeException();
    }

    public Class getRequiredOrderQueryParamClass() {
        return OrderQueryParamInstrument.class;
    }

    static final class ClientIdFlag
    implements BinanceOrderFlags {
        private final String clientId;

        @ConstructorProperties(value={"clientId"})
        @Generated
        public ClientIdFlag(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Generated
        public String getClientId() {
            return this.clientId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientIdFlag)) {
                return false;
            }
            ClientIdFlag other = (ClientIdFlag)o;
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BinanceTradeService.ClientIdFlag(clientId=" + this.getClientId() + ")";
        }
    }

    public static interface BinanceOrderFlags
    extends Order.IOrderFlags {
        public static BinanceOrderFlags withClientId(String clientId) {
            return new ClientIdFlag(clientId);
        }

        public String getClientId();
    }
}

