/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CertHelper {
    public static SSLSocketFactory createExpiredAcceptingSSLSocketFactory(final String subjectPrincipalName) {
        try {
            final TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            X509TrustManager trustManager = new X509TrustManager(){

                private X509TrustManager getDefaultTrustManager() {
                    TrustManager[] trustManagers;
                    for (TrustManager trustManager : trustManagers = trustManagerFactory.getTrustManagers()) {
                        if (!(trustManager instanceof X509TrustManager)) continue;
                        return (X509TrustManager)trustManager;
                    }
                    throw new IllegalStateException();
                }

                private boolean certificateMatches(X509Certificate[] certs, boolean needsToBeExpired) {
                    for (X509Certificate cert : certs) {
                        if (!cert.getSubjectX500Principal().getName().equals(subjectPrincipalName) || needsToBeExpired && !cert.getNotAfter().before(new Date())) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return this.getDefaultTrustManager().getAcceptedIssuers();
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                    System.out.println("checking client trusted: " + Arrays.toString(certs));
                    this.getDefaultTrustManager().checkClientTrusted(certs, authType);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                    try {
                        this.getDefaultTrustManager().checkServerTrusted(certs, authType);
                        if (this.certificateMatches(certs, false)) {
                            throw new CertificateException("Update code to reject expired certificate, up-to-date certificate found: " + subjectPrincipalName);
                        }
                    }
                    catch (CertificateException e) {
                        for (Throwable t = e; t != null; t = t.getCause()) {
                            if (!(t instanceof CertificateExpiredException) || !this.certificateMatches(certs, true)) continue;
                            return;
                        }
                        throw e;
                    }
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static SSLSocketFactory createRestrictedSSLSocketFactory(String ... disabledProtocolsAndCiphers) {
        final CopyOnWriteArraySet<String> disabled = new CopyOnWriteArraySet<String>(Arrays.asList(disabledProtocolsAndCiphers));
        return new SSLSocketFactory(){

            private String[] filter(String[] original, String[] supported) throws IOException {
                CopyOnWriteArraySet<String> filtered = new CopyOnWriteArraySet<String>(Arrays.asList(original));
                filtered.removeAll(disabled);
                if (filtered.isEmpty()) {
                    filtered.addAll(Arrays.asList(supported));
                    filtered.removeAll(disabled);
                }
                if (filtered.isEmpty()) {
                    throw new IOException("No supported SSL attributed enabled.  " + Arrays.toString(original) + " provided, " + disabled.toString() + " disabled, " + Arrays.toString(supported) + " supported, result: " + ((Object)filtered).toString());
                }
                return filtered.toArray(new String[filtered.size()]);
            }

            private SSLSocket fixupSocket(Socket socket) throws IOException {
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setEnabledProtocols(this.filter(sslSocket.getEnabledProtocols(), sslSocket.getSupportedProtocols()));
                sslSocket.setEnabledCipherSuites(this.filter(sslSocket.getEnabledCipherSuites(), sslSocket.getSupportedCipherSuites()));
                return sslSocket;
            }

            private SSLSocketFactory getDefaultFactory() {
                return (SSLSocketFactory)SSLSocketFactory.getDefault();
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return this.getDefaultFactory().getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return this.getDefaultFactory().getSupportedCipherSuites();
            }

            @Override
            public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                return this.fixupSocket(this.getDefaultFactory().createSocket(s, host, port, autoClose));
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException {
                return this.fixupSocket(this.getDefaultFactory().createSocket(host, port));
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
                return this.fixupSocket(this.getDefaultFactory().createSocket(host, port, localHost, localPort));
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                return this.fixupSocket(this.getDefaultFactory().createSocket(host, port));
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                return this.fixupSocket(this.getDefaultFactory().createSocket(address, port, localAddress, localPort));
            }
        };
    }

    public static HostnameVerifier createIncorrectHostnameVerifier(final String requestHostname, final String certPrincipalName) {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                try {
                    String principalName = session.getPeerPrincipal().getName();
                    if (hostname.equals(requestHostname) && principalName.equals(certPrincipalName)) {
                        return true;
                    }
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
                return HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session);
            }
        };
    }

    @Deprecated
    public static void trustAllCerts() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }
}

