/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.instrument.Instrument;

@JsonDeserialize(builder=Builder.class)
public class StopOrder
extends Order
implements Comparable<StopOrder> {
    private static final long serialVersionUID = -7341286101341375106L;
    protected final BigDecimal stopPrice;
    protected BigDecimal limitPrice = null;
    protected Intention intention = null;
    protected BigDecimal trailValue = null;

    public StopOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal stopPrice) {
        super(type, originalAmount, instrument, id, timestamp);
        this.stopPrice = stopPrice;
    }

    public StopOrder(Order.OrderType type, BigDecimal originalAmount, BigDecimal cumulativeAmount, Instrument instrument, String id, Date timestamp, BigDecimal stopPrice) {
        super(type, originalAmount, instrument, id, timestamp, BigDecimal.ZERO, cumulativeAmount, BigDecimal.ZERO, Order.OrderStatus.PENDING_NEW);
        this.stopPrice = stopPrice;
    }

    public StopOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal stopPrice, BigDecimal averagePrice, BigDecimal cumulativeAmount, Order.OrderStatus status) {
        super(type, originalAmount, instrument, id, timestamp, averagePrice, cumulativeAmount, BigDecimal.ZERO, status);
        this.stopPrice = stopPrice;
    }

    public StopOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal stopPrice, BigDecimal limitPrice, BigDecimal averagePrice, BigDecimal cumulativeAmount, Order.OrderStatus status) {
        this(type, originalAmount, instrument, id, timestamp, stopPrice, limitPrice, averagePrice, cumulativeAmount, BigDecimal.ZERO, status);
    }

    public StopOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal stopPrice, BigDecimal limitPrice, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, Order.OrderStatus status) {
        super(type, originalAmount, instrument, id, timestamp, averagePrice, cumulativeAmount, fee, status);
        this.stopPrice = stopPrice;
        this.limitPrice = limitPrice;
    }

    public StopOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal stopPrice, BigDecimal limitPrice, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, Order.OrderStatus status, String userReference, Intention intention, BigDecimal trailValue) {
        super(type, originalAmount, instrument, id, timestamp, averagePrice, cumulativeAmount, fee, status, userReference);
        this.stopPrice = stopPrice;
        this.limitPrice = limitPrice;
        this.intention = intention;
        this.trailValue = trailValue;
    }

    public BigDecimal getStopPrice() {
        return this.stopPrice;
    }

    public BigDecimal getLimitPrice() {
        return this.limitPrice;
    }

    public Intention getIntention() {
        return this.intention;
    }

    public BigDecimal getTrailValue() {
        return this.trailValue;
    }

    @Override
    public String toString() {
        return "StopOrder{stopPrice=" + this.stopPrice + ", limitPrice=" + this.limitPrice + ", intention=" + (Object)((Object)this.intention) + ", trailValue=" + this.trailValue + '}';
    }

    @Override
    public int compareTo(StopOrder stopOrder) {
        if (this.getType() != stopOrder.getType()) {
            return this.getType() == Order.OrderType.BID ? -1 : 1;
        }
        if (this.getStopPrice().compareTo(stopOrder.getStopPrice()) != 0) {
            return this.getType() == Order.OrderType.BID ? -1 : 1;
        }
        return ObjectUtils.compare((Comparable)((Object)this.getIntention()), (Comparable)((Object)stopOrder.getIntention()));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StopOrder)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StopOrder stopOrder = (StopOrder)obj;
        if (!Objects.equals(this.stopPrice, stopOrder.stopPrice)) {
            return false;
        }
        if (!Objects.equals(this.limitPrice, stopOrder.limitPrice)) {
            return false;
        }
        if (!Objects.equals((Object)this.intention, (Object)stopOrder.intention)) {
            return false;
        }
        return Objects.equals(this.trailValue, stopOrder.trailValue);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.stopPrice.hashCode();
        result = 31 * result + (this.limitPrice != null ? this.limitPrice.hashCode() : 0);
        result = 31 * result + (this.intention != null ? this.intention.hashCode() : 0);
        result = 31 * result + (this.trailValue != null ? this.trailValue.hashCode() : 0);
        return result;
    }

    public static enum Intention {
        STOP_LOSS,
        TAKE_PROFIT;

    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends Order.Builder {
        protected BigDecimal stopPrice;
        protected BigDecimal limitPrice;
        protected Intention intention;
        protected BigDecimal trailValue;

        @JsonCreator
        public Builder(@JsonProperty(value="orderType") Order.OrderType orderType, @JsonProperty(value="instrument") Instrument instrument) {
            super(orderType, instrument);
        }

        public static Builder from(Order order) {
            Builder builder = ((Builder)new Builder(order.getType(), order.getInstrument()).originalAmount(order.getOriginalAmount()).cumulativeAmount(order.getCumulativeAmount()).timestamp(order.getTimestamp()).id(order.getId()).flags((Set)order.getOrderFlags())).orderStatus(order.getStatus()).fee(order.getFee()).averagePrice(order.getAveragePrice()).userReference(order.getUserReference());
            if (order instanceof StopOrder) {
                StopOrder stopOrder = (StopOrder)order;
                builder.stopPrice(stopOrder.getStopPrice());
                builder.limitPrice(stopOrder.getLimitPrice());
                builder.intention(stopOrder.getIntention());
                builder.trailValue(stopOrder.getTrailValue());
            }
            return builder;
        }

        @Override
        public Builder orderType(Order.OrderType orderType) {
            return (Builder)super.orderType(orderType);
        }

        @Override
        public Builder originalAmount(BigDecimal originalAmount) {
            return (Builder)super.originalAmount(originalAmount);
        }

        @Override
        public Builder cumulativeAmount(BigDecimal originalAmount) {
            return (Builder)super.cumulativeAmount(originalAmount);
        }

        @Override
        public Builder fee(BigDecimal fee) {
            return (Builder)super.fee(fee);
        }

        @Override
        public Builder remainingAmount(BigDecimal remainingAmount) {
            return (Builder)super.remainingAmount(remainingAmount);
        }

        @Override
        @Deprecated
        public Builder currencyPair(CurrencyPair currencyPair) {
            return (Builder)super.currencyPair(currencyPair);
        }

        @Override
        public Builder instrument(Instrument instrument) {
            return (Builder)super.instrument(instrument);
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder userReference(String userReference) {
            return (Builder)super.userReference(userReference);
        }

        @Override
        public Builder timestamp(Date timestamp) {
            return (Builder)super.timestamp(timestamp);
        }

        @Override
        public Builder orderStatus(Order.OrderStatus status) {
            return (Builder)super.orderStatus(status);
        }

        @Override
        public Builder averagePrice(BigDecimal averagePrice) {
            return (Builder)super.averagePrice(averagePrice);
        }

        @Override
        public Builder flag(Order.IOrderFlags flag) {
            return (Builder)super.flag(flag);
        }

        @Override
        public Builder flags(Set<Order.IOrderFlags> flags) {
            return (Builder)super.flags(flags);
        }

        public Builder stopPrice(BigDecimal stopPrice) {
            this.stopPrice = stopPrice;
            return this;
        }

        public Builder limitPrice(BigDecimal limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public Builder intention(Intention intention) {
            this.intention = intention;
            return this;
        }

        public Builder trailValue(BigDecimal trailValue) {
            this.trailValue = trailValue;
            return this;
        }

        @Override
        public StopOrder build() {
            StopOrder order = new StopOrder(this.orderType, this.originalAmount, this.instrument, this.id, this.timestamp, this.stopPrice, this.limitPrice, this.averagePrice, this.originalAmount == null || this.remainingAmount == null ? this.cumulativeAmount : this.originalAmount.subtract(this.remainingAmount), this.fee, this.status, this.userReference, this.intention, this.trailValue);
            order.setOrderFlags(this.flags);
            order.setLeverage(this.leverage);
            return order;
        }
    }
}

