/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.meta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.meta.RateLimit;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.ObjectMapperHelper;
import org.knowm.xchange.utils.jackson.InstrumentMapDeserializer;

public class ExchangeMetaData
implements Serializable {
    private static final long serialVersionUID = -1495610469981534977L;
    @JsonProperty(value="currency_pairs")
    @JsonDeserialize(keyUsing=InstrumentMapDeserializer.class)
    private Map<Instrument, InstrumentMetaData> instruments;
    @JsonProperty(value="currencies")
    private Map<Currency, CurrencyMetaData> currencies;
    @JsonProperty(value="public_rate_limits")
    private RateLimit[] publicRateLimits;
    @JsonProperty(value="private_rate_limits")
    private RateLimit[] privateRateLimits;
    @JsonProperty(value="share_rate_limits")
    private boolean shareRateLimits;

    public ExchangeMetaData(@JsonProperty(value="currency_pairs") Map<Instrument, InstrumentMetaData> instruments, @JsonProperty(value="currencies") Map<Currency, CurrencyMetaData> currency, @JsonProperty(value="public_rate_limits") RateLimit[] publicRateLimits, @JsonProperty(value="private_rate_limits") RateLimit[] privateRateLimits, @JsonProperty(value="share_rate_limits") Boolean shareRateLimits) {
        this.instruments = instruments;
        this.currencies = currency;
        this.publicRateLimits = publicRateLimits;
        this.privateRateLimits = privateRateLimits;
        this.shareRateLimits = shareRateLimits != null ? shareRateLimits : false;
    }

    @JsonIgnore
    public static Long getPollDelayMillis(RateLimit[] rateLimits) {
        if (rateLimits == null || rateLimits.length == 0) {
            return null;
        }
        long result = 0L;
        for (RateLimit rateLimit : rateLimits) {
            result = Math.max(result, rateLimit.getPollDelayMillis());
        }
        return result;
    }

    @JsonIgnore
    public String toJSONString() {
        return ObjectMapperHelper.toJSON(this);
    }

    @Generated
    public Map<Instrument, InstrumentMetaData> getInstruments() {
        return this.instruments;
    }

    @Generated
    public Map<Currency, CurrencyMetaData> getCurrencies() {
        return this.currencies;
    }

    @Generated
    public RateLimit[] getPublicRateLimits() {
        return this.publicRateLimits;
    }

    @Generated
    public RateLimit[] getPrivateRateLimits() {
        return this.privateRateLimits;
    }

    @Generated
    public boolean isShareRateLimits() {
        return this.shareRateLimits;
    }

    @Generated
    public String toString() {
        return "ExchangeMetaData(instruments=" + this.getInstruments() + ", currencies=" + this.getCurrencies() + ", publicRateLimits=" + Arrays.deepToString(this.getPublicRateLimits()) + ", privateRateLimits=" + Arrays.deepToString(this.getPrivateRateLimits()) + ", shareRateLimits=" + this.isShareRateLimits() + ")";
    }
}

