/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBookUpdate;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public final class OrderBook
implements Serializable {
    private static final long serialVersionUID = -7788306758114464314L;
    @JsonIgnore
    public final StampedLock lock = new StampedLock();
    private final List<LimitOrder> asks;
    private final List<LimitOrder> bids;
    private Date timeStamp;

    @JsonCreator
    public OrderBook(@JsonProperty(value="timeStamp") Date timeStamp, @JsonProperty(value="asks") List<LimitOrder> asks, @JsonProperty(value="bids") List<LimitOrder> bids) {
        this(timeStamp, asks, bids, false);
    }

    public OrderBook(Date timeStamp, List<LimitOrder> asks, List<LimitOrder> bids, boolean sort) {
        this.timeStamp = timeStamp;
        if (sort) {
            this.asks = new ArrayList<LimitOrder>(asks);
            this.bids = new ArrayList<LimitOrder>(bids);
            Collections.sort(this.asks);
            Collections.sort(this.bids);
        } else {
            this.asks = asks;
            this.bids = bids;
        }
    }

    public OrderBook(Date timeStamp, Stream<LimitOrder> asks, Stream<LimitOrder> bids) {
        this(timeStamp, asks, bids, false);
    }

    public OrderBook(Date timeStamp, Stream<LimitOrder> asks, Stream<LimitOrder> bids, boolean sort) {
        this.timeStamp = timeStamp;
        if (sort) {
            this.asks = asks.sorted().collect(Collectors.toList());
            this.bids = bids.sorted().collect(Collectors.toList());
        } else {
            this.asks = asks.collect(Collectors.toList());
            this.bids = bids.collect(Collectors.toList());
        }
    }

    private static LimitOrder withAmount(LimitOrder limitOrder, BigDecimal tradeableAmount) {
        Order.OrderType type = limitOrder.getType();
        Instrument instrument = limitOrder.getInstrument();
        String id = limitOrder.getId();
        Date date = limitOrder.getTimestamp();
        BigDecimal limit = limitOrder.getLimitPrice();
        return new LimitOrder(type, tradeableAmount, instrument, id, date, limit);
    }

    public List<LimitOrder> getOrders(Order.OrderType type) {
        return type == Order.OrderType.ASK ? this.asks : this.bids;
    }

    public void update(LimitOrder limitOrder) {
        this.update(this.getOrders(limitOrder.getType()), limitOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(List<LimitOrder> limitOrders, LimitOrder limitOrder) {
        long stamp = this.lock.readLock();
        int idx = Collections.binarySearch(limitOrders, limitOrder);
        try {
            while (true) {
                long writeStamp;
                if ((writeStamp = this.lock.tryConvertToWriteLock(stamp)) != 0L) {
                    stamp = writeStamp;
                    if (idx >= 0) {
                        limitOrders.remove(idx);
                    } else {
                        idx = -idx - 1;
                    }
                    if (limitOrder.getRemainingAmount().compareTo(BigDecimal.ZERO) != 0) {
                        limitOrders.add(idx, limitOrder);
                    }
                    this.updateDate(limitOrder.getTimestamp());
                    break;
                }
                this.lock.unlockRead(stamp);
                stamp = this.lock.writeLock();
                if (!this.recheckIdx(limitOrders, limitOrder, idx)) continue;
                idx = Collections.binarySearch(limitOrders, limitOrder);
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(OrderBookUpdate orderBookUpdate) {
        long stamp = this.lock.readLock();
        LimitOrder limitOrder = orderBookUpdate.getLimitOrder();
        List<LimitOrder> limitOrders = this.getOrders(limitOrder.getType());
        int idx = Collections.binarySearch(limitOrders, limitOrder);
        try {
            while (true) {
                long writeStamp;
                if ((writeStamp = this.lock.tryConvertToWriteLock(stamp)) != 0L) {
                    stamp = writeStamp;
                    if (idx >= 0) {
                        limitOrders.remove(idx);
                    } else {
                        idx = -idx - 1;
                    }
                    if (orderBookUpdate.getTotalVolume().compareTo(BigDecimal.ZERO) != 0) {
                        LimitOrder updatedOrder = OrderBook.withAmount(limitOrder, orderBookUpdate.getTotalVolume());
                        limitOrders.add(idx, updatedOrder);
                    }
                    this.updateDate(limitOrder.getTimestamp());
                    break;
                }
                this.lock.unlockRead(stamp);
                stamp = this.lock.writeLock();
                if (!this.recheckIdx(limitOrders, limitOrder, idx)) continue;
                idx = Collections.binarySearch(limitOrders, limitOrder);
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private boolean recheckIdx(List<LimitOrder> limitOrders, LimitOrder limitOrder, int idx) {
        switch (idx) {
            case 0: {
                if (!limitOrders.isEmpty()) {
                    return limitOrders.get(0).compareTo(limitOrder) != 0;
                }
                return true;
            }
            case -1: {
                if (limitOrders.isEmpty()) {
                    return false;
                }
                return limitOrders.get(0).compareTo(limitOrder) <= 0;
            }
        }
        return true;
    }

    private void updateDate(Date updateDate) {
        if (updateDate != null && (this.timeStamp == null || updateDate.after(this.timeStamp))) {
            this.timeStamp = updateDate;
        }
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + (this.timeStamp != null ? this.timeStamp.hashCode() : 0);
        for (LimitOrder order : this.bids) {
            hash = 31 * hash + order.hashCode();
        }
        for (LimitOrder order : this.asks) {
            hash = 31 * hash + order.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        int index;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBook other = (OrderBook)obj;
        if (this.timeStamp == null ? other.timeStamp != null : !this.timeStamp.equals(other.timeStamp)) {
            return false;
        }
        if (this.bids.size() != other.bids.size()) {
            return false;
        }
        for (index = 0; index < this.bids.size(); ++index) {
            if (this.bids.get(index).equals(other.bids.get(index))) continue;
            return false;
        }
        if (this.asks.size() != other.asks.size()) {
            return false;
        }
        for (index = 0; index < this.asks.size(); ++index) {
            if (this.asks.get(index).equals(other.asks.get(index))) continue;
            return false;
        }
        return true;
    }

    public boolean ordersEqual(OrderBook ob) {
        if (ob == null) {
            return false;
        }
        Date timestamp = new Date();
        OrderBook thisOb = new OrderBook(timestamp, this.getAsks(), this.getBids());
        OrderBook thatOb = new OrderBook(timestamp, ob.getAsks(), ob.getBids());
        return thisOb.equals(thatOb);
    }

    public String toString() {
        return "OrderBook [timestamp: " + this.timeStamp + ", asks=" + this.asks.toString() + ", bids=" + this.bids.toString() + "]";
    }

    @Generated
    public List<LimitOrder> getAsks() {
        return this.asks;
    }

    @Generated
    public List<LimitOrder> getBids() {
        return this.bids;
    }

    @Generated
    public Date getTimeStamp() {
        return this.timeStamp;
    }
}

