/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.knowm.xchange.instrument.Instrument;

public class FundingRate {
    private final Instrument instrument;
    private final BigDecimal fundingRate1h;
    private final BigDecimal fundingRate8h;
    private final Date fundingRateDate;
    private final long fundingRateEffectiveInMinutes;

    public FundingRate(@JsonProperty(value="instrument") Instrument instrument, @JsonProperty(value="fundingRate1h") BigDecimal fundingRate1h, @JsonProperty(value="fundingRate8h") BigDecimal fundingRate8h, @JsonProperty(value="fundingRateDate") Date fundingRateDate, @JsonProperty(value="fundingRateEffectiveInMinutes") long fundingRateEffectiveInMinutes) {
        this.instrument = instrument;
        this.fundingRate1h = fundingRate1h;
        this.fundingRate8h = fundingRate8h;
        this.fundingRateDate = fundingRateDate;
        this.fundingRateEffectiveInMinutes = fundingRateEffectiveInMinutes == 0L && fundingRateDate != null ? FundingRate.calculateFundingRateEffectiveInMinutes(fundingRateDate) : fundingRateEffectiveInMinutes;
    }

    private static long calculateFundingRateEffectiveInMinutes(Date fundingRateDate) {
        return TimeUnit.MILLISECONDS.toMinutes(fundingRateDate.getTime() - Date.from(Instant.now()).getTime());
    }

    @Generated
    public Instrument getInstrument() {
        return this.instrument;
    }

    @Generated
    public BigDecimal getFundingRate1h() {
        return this.fundingRate1h;
    }

    @Generated
    public BigDecimal getFundingRate8h() {
        return this.fundingRate8h;
    }

    @Generated
    public Date getFundingRateDate() {
        return this.fundingRateDate;
    }

    @Generated
    public long getFundingRateEffectiveInMinutes() {
        return this.fundingRateEffectiveInMinutes;
    }

    @Generated
    public String toString() {
        return "FundingRate(instrument=" + this.getInstrument() + ", fundingRate1h=" + this.getFundingRate1h() + ", fundingRate8h=" + this.getFundingRate8h() + ", fundingRateDate=" + this.getFundingRateDate() + ", fundingRateEffectiveInMinutes=" + this.getFundingRateEffectiveInMinutes() + ")";
    }

    public static class Builder {
        protected Instrument instrument;
        protected BigDecimal fundingRate1h;
        protected BigDecimal fundingRate8h;
        protected Date fundingRateDate;
        protected long fundingRateEffectiveInMinutes;

        public Builder instrument(Instrument instrument) {
            this.instrument = instrument;
            return this;
        }

        public Builder fundingRate1h(BigDecimal fundingRate1h) {
            this.fundingRate1h = fundingRate1h;
            return this;
        }

        public Builder fundingRate8h(BigDecimal fundingRate8h) {
            this.fundingRate8h = fundingRate8h;
            return this;
        }

        public Builder fundingRateDate(Date fundingRateDate) {
            this.fundingRateDate = fundingRateDate;
            return this;
        }

        public Builder fundingRateEffectiveInMinutes(long fundingRateEffectiveInMinutes) {
            this.fundingRateEffectiveInMinutes = fundingRateEffectiveInMinutes;
            return this;
        }

        public FundingRate build() {
            return new FundingRate(this.instrument, this.fundingRate1h, this.fundingRate8h, this.fundingRateDate, this.fundingRateEffectiveInMinutes == 0L && this.fundingRateDate != null ? FundingRate.calculateFundingRateEffectiveInMinutes(this.fundingRateDate) : this.fundingRateEffectiveInMinutes);
        }
    }
}

