/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.instrument.Instrument;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="trigger")
@JsonSubTypes(value={@JsonSubTypes.Type(value=LimitOrder.class, name="limit"), @JsonSubTypes.Type(value=StopOrder.class, name="stop"), @JsonSubTypes.Type(value=MarketOrder.class, name="market")})
public abstract class Order
implements Serializable {
    private static final long serialVersionUID = -8132103343647993249L;
    private static final Random random = new Random();
    private final OrderType type;
    private final BigDecimal originalAmount;
    private final Instrument instrument;
    private final String id;
    private final String userReference;
    private final Date timestamp;
    private final Set<IOrderFlags> orderFlags = new HashSet<IOrderFlags>();
    private OrderStatus status;
    private BigDecimal cumulativeAmount;
    private BigDecimal averagePrice;
    private BigDecimal fee;
    private String leverage = null;

    public Order(OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp) {
        this(type, originalAmount, instrument, id, timestamp, null, null, null, null);
    }

    public Order(OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, OrderStatus status) {
        this(type, originalAmount, instrument, id, timestamp, averagePrice, cumulativeAmount, fee, status, Integer.toString(100000000 + random.nextInt(100000000)));
    }

    public Order(OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, OrderStatus status, String userReference) {
        this.type = type;
        this.originalAmount = originalAmount;
        this.instrument = instrument;
        this.id = id;
        this.timestamp = timestamp;
        this.averagePrice = averagePrice;
        this.cumulativeAmount = cumulativeAmount;
        this.fee = fee;
        this.status = status;
        this.userReference = userReference;
    }

    private static String print(BigDecimal value) {
        return value == null ? null : value.toPlainString();
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    public OrderType getType() {
        return this.type;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public BigDecimal getCumulativeAmount() {
        return this.cumulativeAmount;
    }

    public void setCumulativeAmount(BigDecimal cumulativeAmount) {
        this.cumulativeAmount = cumulativeAmount;
    }

    @JsonIgnore
    public BigDecimal getCumulativeCounterAmount() {
        if (this.cumulativeAmount != null && this.averagePrice != null && this.averagePrice.compareTo(BigDecimal.ZERO) > 0) {
            return this.cumulativeAmount.multiply(this.averagePrice);
        }
        return null;
    }

    public BigDecimal getRemainingAmount() {
        if (this.cumulativeAmount != null && this.originalAmount != null) {
            return this.originalAmount.subtract(this.cumulativeAmount);
        }
        return this.originalAmount;
    }

    public BigDecimal getAveragePrice() {
        return this.averagePrice;
    }

    public void setAveragePrice(BigDecimal averagePrice) {
        this.averagePrice = averagePrice;
    }

    @Deprecated
    @JsonIgnore
    public CurrencyPair getCurrencyPair() {
        if (this.instrument == null) {
            return null;
        }
        if (!(this.instrument instanceof CurrencyPair)) {
            throw new IllegalStateException("The instrument of this order is not a currency pair: " + this.instrument);
        }
        return (CurrencyPair)this.instrument;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public String getId() {
        return this.id;
    }

    public String getUserReference() {
        return this.userReference;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Set<IOrderFlags> getOrderFlags() {
        return this.orderFlags;
    }

    public void setOrderFlags(Set<IOrderFlags> flags) {
        this.orderFlags.clear();
        if (flags != null) {
            this.orderFlags.addAll(flags);
        }
    }

    public boolean hasFlag(IOrderFlags flag) {
        return this.orderFlags.contains(flag);
    }

    public void addOrderFlag(IOrderFlags flag) {
        this.orderFlags.add(flag);
    }

    public void setOrderStatus(OrderStatus status) {
        this.status = status;
    }

    public String getLeverage() {
        return this.leverage;
    }

    public void setLeverage(String leverage) {
        this.leverage = leverage;
    }

    public String toString() {
        return "Order [type=" + (Object)((Object)this.type) + ", originalAmount=" + Order.print(this.originalAmount) + ", cumulativeAmount=" + Order.print(this.cumulativeAmount) + ", averagePrice=" + Order.print(this.averagePrice) + ", fee=" + Order.print(this.fee) + ", instrument=" + this.instrument + ", id=" + this.id + ", timestamp=" + this.timestamp + ", status=" + (Object)((Object)this.status) + ", flags=" + this.orderFlags + ", userReference=" + this.userReference + "]";
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 83 * hash + (this.originalAmount != null ? this.originalAmount.hashCode() : 0);
        hash = 83 * hash + (this.instrument != null ? this.instrument.hashCode() : 0);
        hash = 83 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 83 * hash + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.originalAmount == null ? other.originalAmount != null : this.originalAmount.compareTo(other.originalAmount) != 0) {
            return false;
        }
        if (this.instrument == null ? other.instrument != null : !this.instrument.equals(other.instrument)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.timestamp == other.timestamp || this.timestamp != null && this.timestamp.equals(other.timestamp);
    }

    public static enum OrderType {
        BID,
        ASK,
        EXIT_ASK,
        EXIT_BID;


        public OrderType getOpposite() {
            switch (this.ordinal()) {
                case 0: {
                    return ASK;
                }
                case 1: {
                    return BID;
                }
                case 2: {
                    return EXIT_BID;
                }
                case 3: {
                    return EXIT_ASK;
                }
            }
            return null;
        }
    }

    public static enum OrderStatus {
        PENDING_NEW,
        NEW,
        PARTIALLY_FILLED,
        FILLED,
        PENDING_CANCEL,
        PARTIALLY_CANCELED,
        CANCELED,
        PENDING_REPLACE,
        REPLACED,
        STOPPED,
        REJECTED,
        EXPIRED,
        OPEN,
        CLOSED,
        UNKNOWN;


        public boolean isFinal() {
            switch (this.ordinal()) {
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    return true;
                }
            }
            return false;
        }

        public boolean isOpen() {
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 12: {
                    return true;
                }
            }
            return false;
        }
    }

    public static abstract class Builder {
        protected final Set<IOrderFlags> flags = new HashSet<IOrderFlags>();
        protected OrderType orderType;
        protected BigDecimal originalAmount;
        protected BigDecimal cumulativeAmount;
        protected BigDecimal remainingAmount;
        protected Instrument instrument;
        protected String id;
        protected String userReference;
        protected Date timestamp;
        protected BigDecimal averagePrice;
        protected OrderStatus status;
        protected BigDecimal fee;
        protected String leverage;

        protected Builder(OrderType orderType, Instrument instrument) {
            this.orderType = orderType;
            this.instrument = instrument;
        }

        @JsonProperty(value="type")
        public Builder orderType(OrderType orderType) {
            this.orderType = orderType;
            return this;
        }

        @JsonProperty(value="status")
        public Builder orderStatus(OrderStatus status) {
            this.status = status;
            return this;
        }

        public Builder originalAmount(BigDecimal originalAmount) {
            this.originalAmount = originalAmount;
            return this;
        }

        public Builder cumulativeAmount(BigDecimal cumulativeAmount) {
            this.cumulativeAmount = cumulativeAmount;
            return this;
        }

        public Builder fee(BigDecimal fee) {
            this.fee = fee;
            return this;
        }

        public Builder remainingAmount(BigDecimal remainingAmount) {
            this.remainingAmount = remainingAmount;
            return this;
        }

        public Builder averagePrice(BigDecimal averagePrice) {
            this.averagePrice = averagePrice;
            return this;
        }

        @Deprecated
        public Builder currencyPair(CurrencyPair currencyPair) {
            this.instrument = currencyPair;
            return this;
        }

        public Builder instrument(Instrument instrument) {
            this.instrument = instrument;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder userReference(String userReference) {
            this.userReference = userReference;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder leverage(String leverage) {
            this.leverage = leverage;
            return this;
        }

        @JsonProperty(value="orderFlags")
        public Builder flags(Set<IOrderFlags> flags) {
            this.flags.addAll(flags);
            return this;
        }

        public Builder flag(IOrderFlags flag) {
            this.flags.add(flag);
            return this;
        }

        public abstract Order build();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    public static interface IOrderFlags {
    }
}

