/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.derivative;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.Derivative;
import org.knowm.xchange.instrument.Instrument;

public class OptionsContract
extends Instrument
implements Derivative,
Comparable<OptionsContract>,
Serializable {
    private static final long serialVersionUID = 4546376909031640294L;
    private static final ThreadLocal<DateFormat> DATE_PARSER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyMMdd"));
    private static final Comparator<OptionsContract> COMPARATOR = Comparator.comparing(OptionsContract::getCurrencyPair).thenComparing(OptionsContract::getExpireDate).thenComparing(OptionsContract::getStrike).thenComparing(OptionsContract::getType);
    private final CurrencyPair currencyPair;
    private final Date expireDate;
    private final BigDecimal strike;
    private final OptionType type;

    private OptionsContract(CurrencyPair currencyPair, Date expireDate, BigDecimal strike, OptionType type) {
        this.currencyPair = currencyPair;
        this.expireDate = expireDate;
        this.strike = strike;
        this.type = type;
    }

    @JsonCreator
    public OptionsContract(String symbol) {
        String[] parts = symbol.split("/");
        if (parts.length != 5) {
            throw new IllegalArgumentException("Could not parse options contract from '" + symbol + "'");
        }
        String base = parts[0];
        String counter = parts[1];
        String expireDate = parts[2];
        String strike = parts[3];
        String type = parts[4];
        this.currencyPair = new CurrencyPair(base, counter);
        try {
            this.expireDate = DATE_PARSER.get().parse(expireDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse expire date from '" + symbol + "'");
        }
        this.strike = new BigDecimal(strike);
        this.type = OptionType.fromString(type);
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public BigDecimal getStrike() {
        return this.strike;
    }

    public OptionType getType() {
        return this.type;
    }

    @Override
    public int compareTo(OptionsContract that) {
        return COMPARATOR.compare(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionsContract contract = (OptionsContract)o;
        return Objects.equals(this.currencyPair, contract.currencyPair) && Objects.equals(this.expireDate, contract.expireDate) && Objects.equals(this.strike, contract.strike) && Objects.equals((Object)this.type, (Object)contract.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currencyPair, this.expireDate, this.strike, this.type});
    }

    @Override
    public Currency getBase() {
        return this.currencyPair.getBase();
    }

    @Override
    public Currency getCounter() {
        return this.currencyPair.getCounter();
    }

    @JsonValue
    public String toString() {
        return this.currencyPair.getBase() + "/" + this.currencyPair.getCounter() + "/" + DATE_PARSER.get().format(this.expireDate) + "/" + this.strike + "/" + this.type.postfix;
    }

    public static enum OptionType {
        CALL("C"),
        PUT("P");

        private final String postfix;

        private OptionType(String postfix) {
            this.postfix = postfix;
        }

        public static OptionType fromString(String s) {
            if (OptionType.CALL.postfix.equalsIgnoreCase(s)) {
                return CALL;
            }
            if (OptionType.PUT.postfix.equalsIgnoreCase(s)) {
                return PUT;
            }
            throw new IllegalArgumentException("Unknown option type: " + s);
        }
    }

    public static final class Builder {
        private CurrencyPair currencyPair;
        private Date expireDate;
        private BigDecimal strike;
        private OptionType type;

        public Builder currencyPair(CurrencyPair val) {
            this.currencyPair = val;
            return this;
        }

        public Builder expireDate(Date val) {
            this.expireDate = val;
            return this;
        }

        public Builder strike(BigDecimal val) {
            this.strike = val;
            return this;
        }

        public Builder type(OptionType val) {
            this.type = val;
            return this;
        }

        public OptionsContract build() {
            return new OptionsContract(this.currencyPair, this.expireDate, this.strike, this.type);
        }
    }
}

