/*
 * Decompiled with CFR 0.152.
 */
package com.surftools.BeanstalkClientImpl;

import com.surftools.BeanstalkClient.BeanstalkException;
import com.surftools.BeanstalkClient.Client;
import com.surftools.BeanstalkClient.Job;
import com.surftools.BeanstalkClientImpl.ExpectedResponse;
import com.surftools.BeanstalkClientImpl.JobImpl;
import com.surftools.BeanstalkClientImpl.ProtocolHandler;
import com.surftools.BeanstalkClientImpl.Request;
import com.surftools.BeanstalkClientImpl.Response;
import java.util.List;
import java.util.Map;

public class ClientImpl
implements Client {
    private static final String VERSION = "1.4.6";
    private static final long MAX_PRIORITY = 0x100000000L;
    private String host;
    private int port;
    private boolean uniqueConnectionPerThread = true;
    private ProtocolHandler aProtocolHandler = null;
    private ThreadLocal<ProtocolHandler> tlProtocolHandler = new ThreadLocal<ProtocolHandler>(){

        @Override
        protected ProtocolHandler initialValue() {
            return new ProtocolHandler(ClientImpl.this.host, ClientImpl.this.port);
        }
    };

    private ProtocolHandler getProtocolHandler() {
        if (this.uniqueConnectionPerThread) {
            return this.tlProtocolHandler.get();
        }
        return this.aProtocolHandler;
    }

    public ClientImpl() {
        this("localhost", 11300);
    }

    public ClientImpl(String host, int port) {
        this.host = host;
        this.port = port;
        this.aProtocolHandler = new ProtocolHandler(host, port);
    }

    public ClientImpl(boolean useBlockIO) {
        this("localhost", 11300);
        this.getProtocolHandler().setUseBlockIO(useBlockIO);
    }

    public ClientImpl(String host, int port, boolean useBlockIO) {
        this(host, port);
        this.getProtocolHandler().setUseBlockIO(useBlockIO);
    }

    @Override
    public long put(long priority, int delaySeconds, int timeToRun, byte[] data) {
        if (data == null) {
            throw new BeanstalkException("null data");
        }
        if (priority > 0x100000000L) {
            throw new BeanstalkException("invalid priority");
        }
        long jobId = -1L;
        Request request = new Request("put " + priority + " " + delaySeconds + " " + timeToRun + " " + data.length, new String[]{"INSERTED", "BURIED"}, new String[]{"JOB_TOO_BIG"}, data, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        if (response != null && response.getStatus().equals("JOB_TOO_BIG")) {
            BeanstalkException be = new BeanstalkException(response.getStatus());
            throw be;
        }
        if (response != null && response.isMatchOk()) {
            jobId = Long.parseLong(response.getReponse());
        }
        return jobId;
    }

    @Override
    public void useTube(String tubeName) {
        if (tubeName == null) {
            throw new BeanstalkException("null tubeName");
        }
        Request request = new Request("use " + tubeName, "USING", null, null, ExpectedResponse.None);
        this.getProtocolHandler().processRequest(request);
    }

    @Override
    public Job reserve(Integer timeoutSeconds) {
        JobImpl job = null;
        String command = timeoutSeconds == null ? "reserve" : "reserve-with-timeout " + timeoutSeconds.toString();
        Request request = new Request(command, new String[]{"RESERVED"}, new String[]{"DEADLINE_SOON", "TIMED_OUT"}, null, ExpectedResponse.ByteArray, 2);
        Response response = this.getProtocolHandler().processRequest(request);
        if (response != null && response.getStatus().equals("DEADLINE_SOON")) {
            BeanstalkException be = new BeanstalkException(response.getStatus());
            throw be;
        }
        if (response != null && response.isMatchOk()) {
            long jobId = Long.parseLong(response.getReponse());
            job = new JobImpl(jobId);
            job.setData((byte[])response.getData());
        }
        return job;
    }

    @Override
    public boolean delete(long jobId) {
        Request request = new Request("delete " + jobId, "DELETED", "NOT_FOUND", null, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        return response != null && response.isMatchOk();
    }

    @Override
    public boolean release(long jobId, long priority, int delaySeconds) {
        Request request = new Request("release " + jobId + " " + priority + " " + delaySeconds, new String[]{"RELEASED"}, new String[]{"NOT_FOUND", "BURIED"}, null, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        return response != null && response.isMatchOk();
    }

    @Override
    public boolean bury(long jobId, long priority) {
        Request request = new Request("bury " + jobId + " " + priority, "BURIED", "NOT_FOUND", null, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        return response != null && response.isMatchOk();
    }

    @Override
    public boolean touch(long jobId) {
        Request request = new Request("touch " + jobId, "TOUCHED", "NOT_FOUND", null, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        return response != null && response.isMatchOk();
    }

    @Override
    public int watch(String tubeName) {
        if (tubeName == null) {
            throw new BeanstalkException("null tubeName");
        }
        Request request = new Request("watch " + tubeName, "WATCHING", null, null, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        return Integer.parseInt(response.getReponse());
    }

    @Override
    public int ignore(String tubeName) {
        if (tubeName == null) {
            throw new BeanstalkException("null tubeName");
        }
        Request request = new Request("ignore " + tubeName, new String[]{"WATCHING", "NOT_IGNORED"}, null, null, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        return response.getReponse() == null ? -1 : Integer.parseInt(response.getReponse());
    }

    @Override
    public Job peek(long jobId) {
        JobImpl job = null;
        Request request = new Request("peek " + jobId, "FOUND", "NOT_FOUND", null, ExpectedResponse.ByteArray, 2);
        Response response = this.getProtocolHandler().processRequest(request);
        if (response != null && response.isMatchOk()) {
            jobId = Long.parseLong(response.getReponse());
            job = new JobImpl(jobId);
            job.setData((byte[])response.getData());
        }
        return job;
    }

    @Override
    public Job peekBuried() {
        JobImpl job = null;
        Request request = new Request("peek-buried", "FOUND", "NOT_FOUND", null, ExpectedResponse.ByteArray, 2);
        Response response = this.getProtocolHandler().processRequest(request);
        if (response != null && response.isMatchOk()) {
            long jobId = Long.parseLong(response.getReponse());
            job = new JobImpl(jobId);
            job.setData((byte[])response.getData());
        }
        return job;
    }

    @Override
    public Job peekDelayed() {
        JobImpl job = null;
        Request request = new Request("peek-delayed", "FOUND", "NOT_FOUND", null, ExpectedResponse.ByteArray, 2);
        Response response = this.getProtocolHandler().processRequest(request);
        if (response != null && response.isMatchOk()) {
            long jobId = Long.parseLong(response.getReponse());
            job = new JobImpl(jobId);
            job.setData((byte[])response.getData());
        }
        return job;
    }

    @Override
    public Job peekReady() {
        JobImpl job = null;
        Request request = new Request("peek-ready", "FOUND", "NOT_FOUND", null, ExpectedResponse.ByteArray, 2);
        Response response = this.getProtocolHandler().processRequest(request);
        if (response != null && response.isMatchOk()) {
            long jobId = Long.parseLong(response.getReponse());
            job = new JobImpl(jobId);
            job.setData((byte[])response.getData());
        }
        return job;
    }

    @Override
    public int kick(int count) {
        Request request = new Request("kick " + count, "KICKED", null, null, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        if (response != null && response.isMatchOk()) {
            count = Integer.parseInt(response.getReponse());
        }
        return count;
    }

    @Override
    public Map<String, String> statsJob(long jobId) {
        Request request = new Request("stats-job " + jobId, "OK", "NOT_FOUND", null, ExpectedResponse.Map);
        Response response = this.getProtocolHandler().processRequest(request);
        Map map = null;
        if (response != null && response.isMatchOk()) {
            map = (Map)response.getData();
        }
        return map;
    }

    @Override
    public Map<String, String> statsTube(String tubeName) {
        if (tubeName == null) {
            return null;
        }
        Request request = new Request("stats-tube " + tubeName, "OK", "NOT_FOUND", null, ExpectedResponse.Map);
        Response response = this.getProtocolHandler().processRequest(request);
        Map map = null;
        if (response != null && response.isMatchOk()) {
            map = (Map)response.getData();
        }
        return map;
    }

    @Override
    public Map<String, String> stats() {
        Request request = new Request("stats", "OK", null, null, ExpectedResponse.Map);
        Response response = this.getProtocolHandler().processRequest(request);
        Map map = null;
        if (response != null && response.isMatchOk()) {
            map = (Map)response.getData();
        }
        return map;
    }

    @Override
    public List<String> listTubes() {
        Request request = new Request("list-tubes", "OK", null, null, ExpectedResponse.List);
        Response response = this.getProtocolHandler().processRequest(request);
        List list = null;
        if (response != null && response.isMatchOk()) {
            list = (List)response.getData();
        }
        return list;
    }

    @Override
    public String listTubeUsed() {
        String tubeName = null;
        Request request = new Request("list-tube-used", "USING", null, null, ExpectedResponse.None);
        Response response = this.getProtocolHandler().processRequest(request);
        if (response != null && response.isMatchOk()) {
            tubeName = response.getReponse();
        }
        return tubeName;
    }

    @Override
    public List<String> listTubesWatched() {
        Request request = new Request("list-tubes-watched", "OK", null, null, ExpectedResponse.List);
        Response response = this.getProtocolHandler().processRequest(request);
        List list = null;
        if (response != null && response.isMatchOk()) {
            list = (List)response.getData();
        }
        return list;
    }

    @Override
    public String getClientVersion() {
        return VERSION;
    }

    @Override
    public void close() {
        this.getProtocolHandler().close();
    }

    @Override
    public boolean isUniqueConnectionPerThread() {
        return this.uniqueConnectionPerThread;
    }

    @Override
    public void setUniqueConnectionPerThread(boolean uniqueConnectionPerThread) {
        this.uniqueConnectionPerThread = uniqueConnectionPerThread;
    }

    @Override
    public String getServerVersion() {
        Map<String, String> stats = this.stats();
        if (stats == null) {
            throw new BeanstalkException("could not get stats");
        }
        return stats.get("version").trim();
    }
}

