/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.component.vertx.http.VertxHttpEndpoint;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class VertxHttpHelper {
    private VertxHttpHelper() {
    }

    public static String resolveQueryString(Exchange exchange) throws URISyntaxException {
        Message message = exchange.getMessage();
        String queryString = (String)message.removeHeader("CamelRestHttpQuery");
        if (ObjectHelper.isEmpty((String)queryString)) {
            queryString = (String)message.getHeader("CamelHttpQuery", String.class);
        }
        String uriString = (String)message.getHeader("CamelHttpUri", String.class);
        uriString = exchange.getContext().resolvePropertyPlaceholders(uriString);
        if (uriString != null) {
            uriString = UnsafeUriCharactersEncoder.encodeHttpURI((String)uriString);
            URI uri = new URI(uriString);
            queryString = uri.getQuery();
        }
        return queryString;
    }

    public static URI resolveHttpURI(Exchange exchange, VertxHttpEndpoint endpoint) throws URISyntaxException {
        Message message = exchange.getMessage();
        Object uri = (String)message.removeHeader("CamelRestHttpUri");
        if (ObjectHelper.isEmpty((String)uri)) {
            uri = (String)message.getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getConfiguration().getHttpUri().toASCIIString();
        }
        uri = exchange.getContext().resolvePropertyPlaceholders((String)uri);
        String path = (String)message.getHeader("CamelHttpPath", String.class);
        if (ObjectHelper.isNotEmpty((String)path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() > 0) {
                if (!((String)uri).endsWith("/")) {
                    uri = (String)uri + "/";
                }
                uri = ((String)uri).concat(path);
            }
        }
        uri = UnsafeUriCharactersEncoder.encodeHttpURI((String)uri);
        return new URI((String)uri);
    }

    public static void writeObjectToStream(OutputStream stream, Object target) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        try {
            oos.writeObject(target);
            oos.flush();
        }
        finally {
            IOHelper.close((Closeable)oos);
        }
    }

    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        Object answer;
        if (is == null) {
            return null;
        }
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static String getCharsetFromExchange(Exchange exchange) {
        String contentType;
        String charset = null;
        if (exchange != null && ObjectHelper.isEmpty((String)(charset = HttpHelper.getCharsetFromContentType((String)(contentType = (String)exchange.getMessage().getHeader("Content-Type", String.class)))))) {
            charset = (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
        }
        return charset;
    }
}

