/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.net.ProxyType;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.vertx.http.DefaultVertxHttpBinding;
import org.apache.camel.component.vertx.http.VertxHttpBinding;
import org.apache.camel.component.vertx.http.VertxHttpConfiguration;
import org.apache.camel.component.vertx.http.VertxHttpEndpoint;
import org.apache.camel.component.vertx.http.VertxHttpRestHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.support.RestProducerFactoryHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

@Component(value="vertx-http")
public class VertxHttpComponent
extends HeaderFilterStrategyComponent
implements RestProducerFactory,
SSLContextParametersAware {
    private volatile boolean managedVertx;
    @Metadata(label="security")
    private String basicAuthUsername;
    @Metadata(label="security")
    private String basicAuthPassword;
    @Metadata(label="security")
    private String bearerToken;
    @Metadata(label="security")
    private SSLContextParameters sslContextParameters;
    @Metadata(label="proxy")
    private String proxyHost;
    @Metadata(label="proxy")
    private Integer proxyPort;
    @Metadata(label="proxy", enums="HTTP,SOCKS4,SOCKS5")
    private ProxyType proxyType;
    @Metadata(label="proxy")
    private String proxyUsername;
    @Metadata(label="proxy")
    private String proxyPassword;
    @Metadata(label="advanced")
    private Vertx vertx;
    @Metadata(label="advanced")
    private VertxOptions vertxOptions;
    @Metadata(label="advanced")
    private VertxHttpBinding vertxHttpBinding;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(label="advanced")
    private boolean allowJavaSerializedObject;
    @Metadata(label="producer", defaultValue="true")
    private boolean responsePayloadAsByteArray = true;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        VertxHttpConfiguration configuration = new VertxHttpConfiguration();
        configuration.setResponsePayloadAsByteArray(this.responsePayloadAsByteArray);
        URI uriHttpUriAddress = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        VertxHttpEndpoint endpoint = new VertxHttpEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getBasicAuthUsername() == null) {
            configuration.setBasicAuthUsername(this.getBasicAuthUsername());
        }
        if (configuration.getBasicAuthPassword() == null) {
            configuration.setBasicAuthPassword(this.getBasicAuthPassword());
        }
        if (configuration.getBearerToken() == null) {
            configuration.setBearerToken(this.getBearerToken());
        }
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.getSslContextParameters());
        }
        if (configuration.getProxyType() == null) {
            configuration.setProxyType(this.getProxyType());
        }
        if (configuration.getProxyHost() == null) {
            configuration.setProxyHost(this.getProxyHost());
        }
        if (configuration.getProxyPort() == null) {
            configuration.setProxyPort(this.getProxyPort());
        }
        if (configuration.getProxyUsername() == null) {
            configuration.setProxyUsername(this.getProxyUsername());
        }
        if (configuration.getProxyPassword() == null) {
            configuration.setProxyPassword(this.getProxyPassword());
        }
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        if (configuration.getVertxHttpBinding() == null) {
            configuration.setVertxHttpBinding(this.getVertxHttpBinding());
        }
        if (configuration.getHeaderFilterStrategy() == null) {
            configuration.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        configuration.setHttpUri(httpUri);
        return endpoint;
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String query;
        RestConfiguration config;
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String scheme = "vertx-http:";
        String url = scheme + host;
        if (!ObjectHelper.isEmpty((String)basePath)) {
            url = url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((String)uriTemplate)) {
            url = url + "/" + uriTemplate;
        }
        if ((config = configuration) == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), null, (String)scheme);
        }
        HashMap map = new HashMap();
        if ((config.getProducerComponent() == null || config.getProducerComponent().equals(scheme)) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (!(query = URISupport.createQueryString(map)).isEmpty()) {
            url = url + "?" + query;
        }
        parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap();
        RestProducerFactoryHelper.setupComponentFor((String)url, (CamelContext)camelContext, (Map)((Map)parameters.remove("component")));
        VertxHttpEndpoint endpoint = (VertxHttpEndpoint)camelContext.getEndpoint(url, parameters);
        String path = uriTemplate != null ? uriTemplate : basePath;
        endpoint.getConfiguration().setHeaderFilterStrategy((HeaderFilterStrategy)new VertxHttpRestHeaderFilterStrategy(path, queryParameters));
        ServiceHelper.startService((Object)((Object)endpoint));
        return endpoint.createProducer();
    }

    protected void doInit() throws Exception {
        Set vertxes;
        if (this.vertx == null && (vertxes = this.getCamelContext().getRegistry().findByType(Vertx.class)).size() == 1) {
            this.vertx = (Vertx)vertxes.iterator().next();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.vertx == null) {
            this.vertx = this.vertxOptions != null ? Vertx.vertx((VertxOptions)this.vertxOptions) : Vertx.vertx();
            this.managedVertx = true;
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.managedVertx && this.vertx != null) {
            this.vertx.close();
        }
        this.vertx = null;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public VertxOptions getVertxOptions() {
        return this.vertxOptions;
    }

    public void setVertxOptions(VertxOptions vertxOptions) {
        this.vertxOptions = vertxOptions;
    }

    public VertxHttpBinding getVertxHttpBinding() {
        if (this.vertxHttpBinding == null) {
            this.vertxHttpBinding = new DefaultVertxHttpBinding();
        }
        return this.vertxHttpBinding;
    }

    public void setVertxHttpBinding(VertxHttpBinding vertxHttpBinding) {
        this.vertxHttpBinding = vertxHttpBinding;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public boolean isAllowJavaSerializedObject() {
        return this.allowJavaSerializedObject;
    }

    public void setAllowJavaSerializedObject(boolean allowJavaSerializedObject) {
        this.allowJavaSerializedObject = allowJavaSerializedObject;
    }

    public boolean isResponsePayloadAsByteArray() {
        return this.responsePayloadAsByteArray;
    }

    public void setResponsePayloadAsByteArray(boolean responsePayloadAsByteArray) {
        this.responsePayloadAsByteArray = responsePayloadAsByteArray;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setBasicAuthUsername(String basicAuthUsername) {
        this.basicAuthUsername = basicAuthUsername;
    }

    public String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    public void setBasicAuthPassword(String basicAuthPassword) {
        this.basicAuthPassword = basicAuthPassword;
    }

    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }
}

