/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.LinkErrorContext;
import com.azure.core.amqp.implementation.AmqpErrorCode;
import com.azure.core.amqp.implementation.AmqpLoggingUtils;
import com.azure.core.amqp.implementation.AmqpMetricsProvider;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.handler.Handler;
import java.util.Objects;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;

abstract class LinkHandler
extends Handler {
    private final String entityPath;
    private final AmqpMetricsProvider metricsProvider;

    LinkHandler(String connectionId, String hostname, String entityPath, AmqpMetricsProvider metricsProvider) {
        super(connectionId, hostname);
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        this.metricsProvider = metricsProvider;
    }

    public void onLinkLocalClose(Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getCondition();
        AmqpLoggingUtils.addErrorCondition(this.logger.atVerbose(), condition).addKeyValue("linkName", link.getName()).addKeyValue("entityPath", this.entityPath).log("onLinkLocalClose");
    }

    public void onLinkRemoteClose(Event event) {
        this.handleRemoteLinkClosed("onLinkRemoteClose", event);
    }

    public void onLinkRemoteDetach(Event event) {
        this.handleRemoteLinkClosed("onLinkRemoteDetach", event);
    }

    public void onLinkFinal(Event event) {
        String linkName = event != null && event.getLink() != null ? event.getLink().getName() : "n/a";
        this.logger.atInfo().addKeyValue("linkName", linkName).addKeyValue("entityPath", this.entityPath).log("onLinkFinal");
        super.close();
    }

    public AmqpErrorContext getErrorContext(Link link) {
        return LinkHandler.getErrorContext(this.getHostname(), this.entityPath, link);
    }

    static AmqpErrorContext getErrorContext(String hostName, String entityPath, Link link) {
        String referenceId = link.getRemoteProperties() != null && link.getRemoteProperties().containsKey(AmqpErrorCode.TRACKING_ID_PROPERTY) ? link.getRemoteProperties().get(AmqpErrorCode.TRACKING_ID_PROPERTY).toString() : link.getName();
        return new LinkErrorContext(hostName, entityPath, referenceId, link.getCredit());
    }

    private void handleRemoteLinkClosed(String eventName, Event event) {
        Link link = event.getLink();
        ErrorCondition condition = link.getRemoteCondition();
        AmqpLoggingUtils.addErrorCondition(this.logger.atInfo(), condition).addKeyValue("linkName", link.getName()).addKeyValue("entityPath", this.entityPath).log(eventName);
        if (link.getLocalState() != EndpointState.CLOSED) {
            this.logger.atInfo().addKeyValue("linkName", link.getName()).addKeyValue("entityPath", this.entityPath).addKeyValue("state", (Object)link.getLocalState()).log("Local link state is not closed.");
            link.setCondition(condition);
            link.close();
        }
        if (condition != null && condition.getCondition() != null) {
            this.metricsProvider.recordHandlerError(AmqpMetricsProvider.ErrorSource.LINK, condition);
            Exception exception = ExceptionUtil.toException(condition.getCondition().toString(), condition.getDescription(), this.getErrorContext(link));
            this.onError(exception);
        } else {
            super.close();
        }
    }
}

