/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpRetryPolicy;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public class ExponentialAmqpRetryPolicy
extends AmqpRetryPolicy {
    private final double retryFactor = this.computeRetryFactor();

    public ExponentialAmqpRetryPolicy(AmqpRetryOptions retryOptions) {
        super(retryOptions);
    }

    @Override
    protected Duration calculateRetryDelay(int retryCount, Duration baseDelay, Duration baseJitter, ThreadLocalRandom random) {
        double jitterSeconds = random.nextDouble() * (double)baseJitter.getSeconds();
        double nextRetrySeconds = Math.pow(this.retryFactor, retryCount);
        Double nextRetryNanos = (jitterSeconds + nextRetrySeconds) * 1.0E9;
        return baseDelay.plus(Duration.ofNanos(nextRetryNanos.longValue()));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof ExponentialAmqpRetryPolicy && super.equals(obj);
    }

    private double computeRetryFactor() {
        AmqpRetryOptions options = this.getRetryOptions();
        Duration maxBackoff = options.getMaxDelay();
        Duration minBackoff = options.getDelay();
        int maximumRetries = options.getMaxRetries();
        long deltaBackoff = maxBackoff.minus(minBackoff).getSeconds();
        if (deltaBackoff <= 0L || maximumRetries <= 0) {
            return 0.0;
        }
        return Math.log(deltaBackoff) / Math.log(maximumRetries);
    }
}

