/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.Messages;
import com.azure.messaging.eventhubs.implementation.SynchronousReceiveWork;
import com.azure.messaging.eventhubs.models.PartitionEvent;
import java.util.Collections;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.reactivestreams.Subscription;
import reactor.core.publisher.BaseSubscriber;
import reactor.util.context.Context;

public class SynchronousEventSubscriber
extends BaseSubscriber<PartitionEvent> {
    private final Timer timer = new Timer();
    private final ClientLogger logger;
    private final SynchronousReceiveWork work;
    private volatile Subscription subscription;
    private final Context context;
    private final String subscriberId;

    public SynchronousEventSubscriber(SynchronousReceiveWork work) {
        this.work = Objects.requireNonNull(work, "'work' cannot be null.");
        this.subscriberId = String.valueOf(work.getId());
        this.context = super.currentContext().put((Object)"subscriberId", (Object)this.subscriberId);
        this.logger = new ClientLogger(SynchronousEventSubscriber.class, Collections.singletonMap("subscriberId", this.subscriberId));
    }

    public Context currentContext() {
        return this.context;
    }

    protected void hookOnSubscribe(Subscription subscription) {
        if (this.subscription == null) {
            this.subscription = subscription;
        }
        this.logger.atInfo().addKeyValue("pendingEvents", (long)this.work.getNumberOfEvents()).log("Scheduling receive timeout task.");
        subscription.request((long)this.work.getNumberOfEvents());
        this.timer.schedule((TimerTask)new ReceiveTimeoutTask(this::dispose, this.logger), this.work.getTimeout().toMillis());
    }

    protected void hookOnNext(PartitionEvent value) {
        this.work.next(value);
        if (this.work.isTerminal()) {
            this.logger.info("Work completed. Closing Flux and cancelling subscription.");
            this.dispose();
        }
    }

    protected void hookOnComplete() {
        this.logger.info("Completed. No events to listen to.");
        this.dispose();
    }

    protected void hookOnError(Throwable throwable) {
        this.logger.error(Messages.ERROR_OCCURRED_IN_SUBSCRIBER_ERROR, new Object[]{throwable});
        this.work.error(throwable);
        this.dispose();
    }

    public void dispose() {
        this.work.complete();
        this.subscription.cancel();
        this.timer.cancel();
        super.dispose();
    }

    private static class ReceiveTimeoutTask
    extends TimerTask {
        private final ClientLogger logger;
        private final Runnable onDispose;

        ReceiveTimeoutTask(Runnable onDispose, ClientLogger logger) {
            this.onDispose = onDispose;
            this.logger = logger;
        }

        @Override
        public void run() {
            this.logger.info("Timeout encountered, disposing of subscriber.");
            this.onDispose.run();
        }
    }
}

