/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.models.LastEnqueuedEventProperties;
import reactor.core.scheduler.Scheduler;

class PartitionPump
implements AutoCloseable {
    private final String partitionId;
    private final EventHubConsumerAsyncClient client;
    private final Scheduler scheduler;
    private LastEnqueuedEventProperties lastEnqueuedEventProperties;
    private final ClientLogger logger = new ClientLogger(PartitionPump.class);

    PartitionPump(String partitionId, EventHubConsumerAsyncClient client, Scheduler scheduler) {
        this.partitionId = partitionId;
        this.client = client;
        this.scheduler = scheduler;
    }

    EventHubConsumerAsyncClient getClient() {
        return this.client;
    }

    LastEnqueuedEventProperties getLastEnqueuedEventProperties() {
        return this.lastEnqueuedEventProperties;
    }

    void setLastEnqueuedEventProperties(LastEnqueuedEventProperties lastEnqueuedEventProperties) {
        this.lastEnqueuedEventProperties = lastEnqueuedEventProperties;
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception error) {
            this.logger.atInfo().addKeyValue("partitionId", this.partitionId).log("Exception occurred disposing of consumer client.", new Object[]{error});
        }
        finally {
            this.scheduler.dispose();
        }
    }
}

