/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.ReflectionUtilsApi;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ReflectionUtils
implements ReflectionUtilsApi {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Module CORE_MODULE = ReflectionUtils.class.getModule();

    @Override
    public MethodHandles.Lookup getLookupToUse(Class<?> targetClass) throws Exception {
        Module responseModule = targetClass.getModule();
        if (!responseModule.isNamed()) {
            CORE_MODULE.addReads(responseModule);
            return ReflectionUtils.performSafePrivateLookupIn(targetClass);
        }
        if (responseModule == CORE_MODULE) {
            return LOOKUP;
        }
        if (responseModule.isOpen(targetClass.getPackageName()) || responseModule.isOpen(targetClass.getPackageName(), CORE_MODULE)) {
            CORE_MODULE.addReads(responseModule);
            return ReflectionUtils.performSafePrivateLookupIn(targetClass);
        }
        return MethodHandles.publicLookup();
    }

    @Override
    public int getJavaImplementationMajorVersion() {
        return 9;
    }

    private static MethodHandles.Lookup performSafePrivateLookupIn(Class<?> targetClass) throws Exception {
        if (System.getSecurityManager() == null) {
            return MethodHandles.privateLookupIn(targetClass, LOOKUP);
        }
        return AccessController.doPrivileged(() -> MethodHandles.privateLookupIn(targetClass, LOOKUP));
    }

    ReflectionUtils() {
    }
}

