/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.stream.StreamSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaRecordProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaRecordProcessor.class);

    protected void setupExchangeMessage(Message message, ConsumerRecord<Object, Object> consumerRecord) {
        message.setHeader("kafka.PARTITION", (Object)consumerRecord.partition());
        message.setHeader("kafka.TOPIC", (Object)consumerRecord.topic());
        message.setHeader("kafka.OFFSET", (Object)consumerRecord.offset());
        message.setHeader("kafka.HEADERS", (Object)consumerRecord.headers());
        message.setHeader("kafka.TIMESTAMP", (Object)consumerRecord.timestamp());
        message.setHeader("CamelMessageTimestamp", (Object)consumerRecord.timestamp());
        if (consumerRecord.key() != null) {
            message.setHeader("kafka.KEY", consumerRecord.key());
        }
        LOG.debug("Setting up the exchange for message from partition {} and offset {}", (Object)consumerRecord.partition(), (Object)consumerRecord.offset());
        message.setBody(consumerRecord.value());
    }

    protected boolean shouldBeFiltered(Header header, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        return !headerFilterStrategy.applyFilterToExternalHeaders(header.key(), (Object)header.value(), exchange);
    }

    protected void propagateHeaders(KafkaConfiguration configuration, ConsumerRecord<Object, Object> consumerRecord, Exchange exchange) {
        HeaderFilterStrategy headerFilterStrategy = configuration.getHeaderFilterStrategy();
        KafkaHeaderDeserializer headerDeserializer = configuration.getHeaderDeserializer();
        StreamSupport.stream(consumerRecord.headers().spliterator(), false).filter(header -> this.shouldBeFiltered((Header)header, exchange, headerFilterStrategy)).forEach(header -> exchange.getIn().setHeader(header.key(), headerDeserializer.deserialize(header.key(), header.value())));
    }
}

