/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.models.CloseContext;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventBatchContext;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.messaging.eventhubs.models.InitializationContext;

public abstract class PartitionProcessor {
    private final ClientLogger logger = new ClientLogger(PartitionProcessor.class);

    public void initialize(InitializationContext initializationContext) {
        this.logger.atInfo().addKeyValue("partitionId", initializationContext.getPartitionContext().getPartitionId()).log("Initializing partition processor for partition");
    }

    public abstract void processEvent(EventContext var1);

    public void processEventBatch(EventBatchContext eventBatchContext) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Processing event batch not implemented"));
    }

    public abstract void processError(ErrorContext var1);

    public void close(CloseContext closeContext) {
        this.logger.atInfo().addKeyValue("partitionId", closeContext.getPartitionContext().getPartitionId()).log("Closing partition processor with close reason {}", new Object[]{closeContext.getCloseReason()});
    }
}

