/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.Messages;
import com.azure.messaging.eventhubs.PartitionPump;
import com.azure.messaging.eventhubs.implementation.PartitionProcessor;
import com.azure.messaging.eventhubs.implementation.PartitionProcessorException;
import com.azure.messaging.eventhubs.models.Checkpoint;
import com.azure.messaging.eventhubs.models.CloseContext;
import com.azure.messaging.eventhubs.models.CloseReason;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventBatchContext;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.messaging.eventhubs.models.InitializationContext;
import com.azure.messaging.eventhubs.models.LastEnqueuedEventProperties;
import com.azure.messaging.eventhubs.models.PartitionContext;
import com.azure.messaging.eventhubs.models.PartitionEvent;
import com.azure.messaging.eventhubs.models.PartitionOwnership;
import com.azure.messaging.eventhubs.models.ReceiveOptions;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Signal;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

class PartitionPumpManager {
    private static final int MAXIMUM_QUEUE_SIZE = 10000;
    private final int schedulerSize = Runtime.getRuntime().availableProcessors() * 4;
    private final ClientLogger logger = new ClientLogger(PartitionPumpManager.class);
    private final CheckpointStore checkpointStore;
    private final Map<String, PartitionPump> partitionPumps = new ConcurrentHashMap<String, PartitionPump>();
    private final Supplier<PartitionProcessor> partitionProcessorFactory;
    private final EventHubClientBuilder eventHubClientBuilder;
    private final TracerProvider tracerProvider;
    private final boolean trackLastEnqueuedEventProperties;
    private final Map<String, EventPosition> initialPartitionEventPosition;
    private final Duration maxWaitTime;
    private final int maxBatchSize;
    private final boolean batchReceiveMode;
    private final int prefetch;

    PartitionPumpManager(CheckpointStore checkpointStore, Supplier<PartitionProcessor> partitionProcessorFactory, EventHubClientBuilder eventHubClientBuilder, boolean trackLastEnqueuedEventProperties, TracerProvider tracerProvider, Map<String, EventPosition> initialPartitionEventPosition, int maxBatchSize, Duration maxWaitTime, boolean batchReceiveMode) {
        this.checkpointStore = checkpointStore;
        this.partitionProcessorFactory = partitionProcessorFactory;
        this.eventHubClientBuilder = eventHubClientBuilder;
        this.trackLastEnqueuedEventProperties = trackLastEnqueuedEventProperties;
        this.tracerProvider = tracerProvider;
        this.initialPartitionEventPosition = initialPartitionEventPosition;
        this.maxBatchSize = maxBatchSize;
        this.maxWaitTime = maxWaitTime;
        this.batchReceiveMode = batchReceiveMode;
        this.prefetch = eventHubClientBuilder.getPrefetchCount() == null ? 500 : eventHubClientBuilder.getPrefetchCount();
    }

    void stopAllPartitionPumps() {
        this.partitionPumps.forEach((partitionId, eventHubConsumer) -> {
            try {
                eventHubConsumer.close();
            }
            catch (Exception ex) {
                this.logger.atWarning().addKeyValue("partitionId", partitionId).log(Messages.FAILED_CLOSE_CONSUMER_PARTITION, new Object[]{ex});
            }
            finally {
                this.partitionPumps.remove(partitionId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyPartitionConnection(PartitionOwnership ownership) {
        String partitionId = ownership.getPartitionId();
        PartitionPump partitionPump = this.partitionPumps.get(partitionId);
        if (partitionPump == null) {
            this.logger.atInfo().addKeyValue("partitionId", partitionId).addKeyValue("entity-path", ownership.getEventHubName()).log("No partition pump found for ownership record.");
            return;
        }
        EventHubConsumerAsyncClient consumerClient = partitionPump.getClient();
        if (consumerClient.isConnectionClosed()) {
            this.logger.atInfo().addKeyValue("partitionId", partitionId).addKeyValue("entity-path", ownership.getEventHubName()).log("Connection closed for partition. Removing the consumer.");
            try {
                partitionPump.close();
            }
            catch (Exception ex) {
                this.logger.atWarning().addKeyValue("partitionId", partitionId).log(Messages.FAILED_CLOSE_CONSUMER_PARTITION, new Object[]{ex});
            }
            finally {
                this.partitionPumps.remove(partitionId);
            }
        }
    }

    void startPartitionPump(PartitionOwnership claimedOwnership, Checkpoint checkpoint) {
        if (this.partitionPumps.containsKey(claimedOwnership.getPartitionId())) {
            this.logger.atVerbose().addKeyValue("partitionId", claimedOwnership.getPartitionId()).log("Consumer is already running.");
            return;
        }
        try {
            PartitionContext partitionContext = new PartitionContext(claimedOwnership.getFullyQualifiedNamespace(), claimedOwnership.getEventHubName(), claimedOwnership.getConsumerGroup(), claimedOwnership.getPartitionId());
            PartitionProcessor partitionProcessor = this.partitionProcessorFactory.get();
            InitializationContext initializationContext = new InitializationContext(partitionContext);
            partitionProcessor.initialize(initializationContext);
            EventPosition startFromEventPosition = checkpoint != null && checkpoint.getOffset() != null ? EventPosition.fromOffset(checkpoint.getOffset()) : (checkpoint != null && checkpoint.getSequenceNumber() != null ? EventPosition.fromSequenceNumber(checkpoint.getSequenceNumber()) : (this.initialPartitionEventPosition.containsKey(claimedOwnership.getPartitionId()) ? this.initialPartitionEventPosition.get(claimedOwnership.getPartitionId()) : EventPosition.latest()));
            this.logger.atInfo().addKeyValue("partitionId", claimedOwnership.getPartitionId()).addKeyValue("eventPosition", (Object)startFromEventPosition).log("Starting event processing.");
            ReceiveOptions receiveOptions = new ReceiveOptions().setOwnerLevel(0L).setTrackLastEnqueuedEventProperties(this.trackLastEnqueuedEventProperties);
            Scheduler scheduler = Schedulers.newBoundedElastic((int)this.schedulerSize, (int)10000, (String)("partition-pump-" + claimedOwnership.getPartitionId()));
            EventHubConsumerAsyncClient eventHubConsumer = this.eventHubClientBuilder.buildAsyncClient().createConsumer(claimedOwnership.getConsumerGroup(), this.prefetch);
            PartitionPump partitionPump = new PartitionPump(claimedOwnership.getPartitionId(), eventHubConsumer, scheduler);
            this.partitionPumps.put(claimedOwnership.getPartitionId(), partitionPump);
            Flux receiver = eventHubConsumer.receiveFromPartition(claimedOwnership.getPartitionId(), startFromEventPosition, receiveOptions).doOnNext(partitionEvent -> {
                if (this.logger.canLogAtLevel(LogLevel.VERBOSE)) {
                    this.logger.atVerbose().addKeyValue("partitionId", partitionContext.getPartitionId()).addKeyValue("entity-path", partitionContext.getEventHubName()).addKeyValue("sequenceNumber", (Object)partitionEvent.getData().getSequenceNumber()).log("On next.");
                }
            });
            Flux partitionEventFlux = this.maxWaitTime != null ? receiver.windowTimeout(this.maxBatchSize, this.maxWaitTime) : receiver.window(this.maxBatchSize);
            partitionEventFlux.concatMap(Flux::collectList).publishOn(scheduler, false, this.prefetch).subscribe(partitionEventBatch -> this.processEvents(partitionContext, partitionProcessor, partitionPump, eventHubConsumer, (List<PartitionEvent>)partitionEventBatch), ex -> this.handleError(claimedOwnership, partitionPump, partitionProcessor, (Throwable)ex, partitionContext), () -> {
                partitionProcessor.close(new CloseContext(partitionContext, CloseReason.EVENT_PROCESSOR_SHUTDOWN));
                this.cleanup(claimedOwnership, partitionPump);
            });
        }
        catch (Exception ex2) {
            if (this.partitionPumps.containsKey(claimedOwnership.getPartitionId())) {
                this.cleanup(claimedOwnership, this.partitionPumps.get(claimedOwnership.getPartitionId()));
            }
            throw this.logger.atError().addKeyValue("partitionId", claimedOwnership.getPartitionId()).log((RuntimeException)((Object)new PartitionProcessorException("Error occurred while starting partition pump for partition " + claimedOwnership.getPartitionId(), ex2)));
        }
    }

    private void processEvent(PartitionContext partitionContext, PartitionProcessor partitionProcessor, EventHubConsumerAsyncClient eventHubConsumer, EventContext eventContext) {
        Context processSpanContext = null;
        EventData eventData = eventContext.getEventData();
        if (eventData != null && (processSpanContext = this.startProcessTracingSpan(eventData, eventHubConsumer.getEventHubName(), eventHubConsumer.getFullyQualifiedNamespace())).getData((Object)"span-context").isPresent()) {
            eventData.addContext("span-context", processSpanContext);
        }
        try {
            if (this.logger.canLogAtLevel(LogLevel.VERBOSE)) {
                this.logger.atVerbose().addKeyValue("partitionId", partitionContext.getPartitionId()).addKeyValue("entity-path", partitionContext.getEventHubName()).log("Processing event.");
            }
            partitionProcessor.processEvent(new EventContext(partitionContext, eventData, this.checkpointStore, eventContext.getLastEnqueuedEventProperties()));
            if (this.logger.canLogAtLevel(LogLevel.VERBOSE)) {
                this.logger.atVerbose().addKeyValue("partitionId", partitionContext.getPartitionId()).addKeyValue("entity-path", partitionContext.getEventHubName()).log("Completed processing event.");
            }
            this.endProcessTracingSpan(processSpanContext, (Signal<Void>)Signal.complete());
        }
        catch (Throwable throwable) {
            this.endProcessTracingSpan(processSpanContext, (Signal<Void>)Signal.error((Throwable)throwable));
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new PartitionProcessorException("Error in event processing callback", throwable)));
        }
    }

    private void processEvents(PartitionContext partitionContext, PartitionProcessor partitionProcessor, PartitionPump partitionPump, EventHubConsumerAsyncClient eventHubConsumer, List<PartitionEvent> partitionEventBatch) {
        try {
            if (this.batchReceiveMode) {
                LastEnqueuedEventProperties[] lastEnqueuedEventProperties = new LastEnqueuedEventProperties[1];
                List<EventData> eventDataList = partitionEventBatch.stream().map(partitionEvent -> {
                    lastEnqueuedEventProperties[0] = partitionEvent.getLastEnqueuedEventProperties();
                    return partitionEvent.getData();
                }).collect(Collectors.toList());
                LastEnqueuedEventProperties enqueuedEventProperties = this.updateOrGetLastEnqueuedEventProperties(partitionPump, lastEnqueuedEventProperties[0]);
                EventBatchContext eventBatchContext = new EventBatchContext(partitionContext, eventDataList, this.checkpointStore, enqueuedEventProperties);
                if (this.logger.canLogAtLevel(LogLevel.VERBOSE)) {
                    this.logger.atVerbose().addKeyValue("partitionId", partitionContext.getPartitionId()).addKeyValue("entity-path", partitionContext.getEventHubName()).log("Processing event batch.");
                }
                partitionProcessor.processEventBatch(eventBatchContext);
                if (this.logger.canLogAtLevel(LogLevel.VERBOSE)) {
                    this.logger.atVerbose().addKeyValue("partitionId", partitionContext.getPartitionId()).addKeyValue("entity-path", partitionContext.getEventHubName()).log("Completed processing event batch.");
                }
            } else {
                EventData eventData = partitionEventBatch.size() == 1 ? partitionEventBatch.get(0).getData() : null;
                LastEnqueuedEventProperties lastEnqueuedEventProperties = partitionEventBatch.size() == 1 ? partitionEventBatch.get(0).getLastEnqueuedEventProperties() : null;
                LastEnqueuedEventProperties enqueuedEventProperties = this.updateOrGetLastEnqueuedEventProperties(partitionPump, lastEnqueuedEventProperties);
                EventContext eventContext = new EventContext(partitionContext, eventData, this.checkpointStore, enqueuedEventProperties);
                this.processEvent(partitionContext, partitionProcessor, eventHubConsumer, eventContext);
            }
        }
        catch (Throwable throwable) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new PartitionProcessorException("Error in event processing callback", throwable)));
        }
    }

    Map<String, PartitionPump> getPartitionPumps() {
        return this.partitionPumps;
    }

    private void handleError(PartitionOwnership claimedOwnership, PartitionPump partitionPump, PartitionProcessor partitionProcessor, Throwable throwable, PartitionContext partitionContext) {
        boolean shouldRethrow = true;
        if (!(throwable instanceof PartitionProcessorException)) {
            shouldRethrow = false;
            this.logger.atWarning().addKeyValue("partitionId", partitionContext.getPartitionId()).log("Error receiving events from partition.", new Object[]{throwable});
            partitionProcessor.processError(new ErrorContext(partitionContext, throwable));
        }
        CloseReason closeReason = CloseReason.LOST_PARTITION_OWNERSHIP;
        partitionProcessor.close(new CloseContext(partitionContext, closeReason));
        this.cleanup(claimedOwnership, partitionPump);
        if (shouldRethrow) {
            PartitionProcessorException exception = (PartitionProcessorException)((Object)throwable);
            throw this.logger.logExceptionAsError((RuntimeException)((Object)exception));
        }
    }

    private void cleanup(PartitionOwnership claimedOwnership, PartitionPump partitionPump) {
        try {
            this.logger.atInfo().addKeyValue("partitionId", claimedOwnership.getPartitionId()).log("Closing consumer.");
            partitionPump.close();
        }
        finally {
            this.logger.atInfo().addKeyValue("partitionId", claimedOwnership.getPartitionId()).log("Removing partition from list of processing partitions.");
            this.partitionPumps.remove(claimedOwnership.getPartitionId());
        }
    }

    private Context startProcessTracingSpan(EventData eventData, String eventHubName, String fullyQualifiedNamespace) {
        Object diagnosticId = eventData.getProperties().get("Diagnostic-Id");
        if (this.tracerProvider == null || !this.tracerProvider.isEnabled()) {
            return Context.NONE;
        }
        Context spanContext = Objects.isNull(diagnosticId) ? Context.NONE : this.tracerProvider.extractContext(diagnosticId.toString(), Context.NONE);
        spanContext = spanContext.addData((Object)"entity-path", (Object)eventHubName).addData((Object)"hostname", (Object)fullyQualifiedNamespace).addData((Object)"az.namespace", (Object)"Microsoft.EventHub");
        spanContext = eventData.getEnqueuedTime() == null ? spanContext : spanContext.addData((Object)"x-opt-enqueued-time", (Object)eventData.getEnqueuedTime().getEpochSecond());
        return this.tracerProvider.startSpan("EventHubs.", spanContext, ProcessKind.PROCESS);
    }

    private void endProcessTracingSpan(Context processSpanContext, Signal<Void> signal) {
        if (processSpanContext == null) {
            return;
        }
        Optional spanScope = processSpanContext.getData((Object)"scope");
        if (!spanScope.isPresent() || !this.tracerProvider.isEnabled()) {
            return;
        }
        Object spanObject = spanScope.get();
        if (spanObject instanceof AutoCloseable) {
            AutoCloseable close = (AutoCloseable)spanObject;
            try {
                close.close();
            }
            catch (Exception exception) {
                this.logger.error(Messages.EVENT_PROCESSOR_RUN_END, new Object[]{exception});
            }
        } else {
            this.logger.verbose(String.format(Locale.US, Messages.PROCESS_SPAN_SCOPE_TYPE_ERROR, spanObject != null ? spanObject.getClass() : "null"));
        }
        this.tracerProvider.endSpan(processSpanContext, signal);
    }

    private LastEnqueuedEventProperties updateOrGetLastEnqueuedEventProperties(PartitionPump partitionPump, LastEnqueuedEventProperties last) {
        if (last != null) {
            partitionPump.setLastEnqueuedEventProperties(last);
        }
        return partitionPump.getLastEnqueuedEventProperties();
    }
}

