/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubAsyncClient;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.LoadBalancingStrategy;
import com.azure.messaging.eventhubs.PartitionBasedLoadBalancer;
import com.azure.messaging.eventhubs.PartitionPumpManager;
import com.azure.messaging.eventhubs.implementation.PartitionProcessor;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventPosition;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@ServiceClient(builder=EventProcessorClientBuilder.class)
public class EventProcessorClient {
    private static final long BASE_JITTER_IN_SECONDS = 2L;
    private final ClientLogger logger;
    private final String identifier;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final PartitionPumpManager partitionPumpManager;
    private final PartitionBasedLoadBalancer partitionBasedLoadBalancer;
    private final CheckpointStore checkpointStore;
    private final AtomicReference<ScheduledFuture<?>> runner = new AtomicReference();
    private final AtomicReference<ScheduledExecutorService> scheduler = new AtomicReference();
    private final String fullyQualifiedNamespace;
    private final String eventHubName;
    private final String consumerGroup;
    private final Duration loadBalancerUpdateInterval;

    EventProcessorClient(EventHubClientBuilder eventHubClientBuilder, String consumerGroup, Supplier<PartitionProcessor> partitionProcessorFactory, CheckpointStore checkpointStore, boolean trackLastEnqueuedEventProperties, TracerProvider tracerProvider, Consumer<ErrorContext> processError, Map<String, EventPosition> initialPartitionEventPosition, int maxBatchSize, Duration maxWaitTime, boolean batchReceiveMode, Duration loadBalancerUpdateInterval, Duration partitionOwnershipExpirationInterval, LoadBalancingStrategy loadBalancingStrategy) {
        Objects.requireNonNull(eventHubClientBuilder, "eventHubClientBuilder cannot be null.");
        Objects.requireNonNull(consumerGroup, "consumerGroup cannot be null.");
        Objects.requireNonNull(partitionProcessorFactory, "partitionProcessorFactory cannot be null.");
        EventHubAsyncClient eventHubAsyncClient = eventHubClientBuilder.buildAsyncClient();
        this.checkpointStore = Objects.requireNonNull(checkpointStore, "checkpointStore cannot be null");
        this.identifier = UUID.randomUUID().toString();
        HashMap<String, String> loggingContext = new HashMap<String, String>();
        loggingContext.put("eventProcessorId", this.identifier);
        this.logger = new ClientLogger(EventProcessorClient.class, loggingContext);
        this.fullyQualifiedNamespace = eventHubAsyncClient.getFullyQualifiedNamespace().toLowerCase(Locale.ROOT);
        this.eventHubName = eventHubAsyncClient.getEventHubName().toLowerCase(Locale.ROOT);
        this.consumerGroup = consumerGroup.toLowerCase(Locale.ROOT);
        this.loadBalancerUpdateInterval = loadBalancerUpdateInterval;
        this.partitionPumpManager = new PartitionPumpManager(checkpointStore, partitionProcessorFactory, eventHubClientBuilder, trackLastEnqueuedEventProperties, tracerProvider, initialPartitionEventPosition, maxBatchSize, maxWaitTime, batchReceiveMode);
        this.partitionBasedLoadBalancer = new PartitionBasedLoadBalancer(this.checkpointStore, eventHubAsyncClient, this.fullyQualifiedNamespace, this.eventHubName, this.consumerGroup, this.identifier, partitionOwnershipExpirationInterval.getSeconds(), this.partitionPumpManager, processError, loadBalancingStrategy);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public synchronized void start() {
        if (!this.isRunning.compareAndSet(false, true)) {
            this.logger.info("Event processor is already running");
            return;
        }
        this.logger.info("Starting a new event processor instance.");
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.set(executor);
        Double jitterInMillis = ThreadLocalRandom.current().nextDouble() * (double)TimeUnit.SECONDS.toMillis(2L);
        this.runner.set(this.scheduler.get().scheduleWithFixedDelay(this.partitionBasedLoadBalancer::loadBalance, jitterInMillis.longValue(), this.loadBalancerUpdateInterval.toMillis(), TimeUnit.MILLISECONDS));
    }

    public synchronized void stop() {
        if (!this.isRunning.compareAndSet(true, false)) {
            this.logger.info("Event processor has already stopped");
            return;
        }
        this.runner.get().cancel(true);
        this.scheduler.get().shutdown();
        this.stopProcessing();
    }

    public synchronized boolean isRunning() {
        return this.isRunning.get();
    }

    private void stopProcessing() {
        this.partitionPumpManager.stopAllPartitionPumps();
        this.checkpointStore.listOwnership(this.fullyQualifiedNamespace, this.eventHubName, this.consumerGroup).filter(ownership -> this.identifier.equals(ownership.getOwnerId())).map(ownership -> ownership.setOwnerId("")).collect(Collectors.toList()).flatMapMany(this.checkpointStore::claimOwnership).blockLast(Duration.ofSeconds(10L));
    }
}

