/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.implementation.AmqpReceiveLink;
import com.azure.core.util.logging.ClientLogger;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.proton.message.Message;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Exceptions;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public class AmqpReceiveLinkProcessor
extends FluxProcessor<AmqpReceiveLink, Message>
implements Subscription {
    private final ClientLogger logger = new ClientLogger(AmqpReceiveLinkProcessor.class);
    private final Object lock = new Object();
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    private final AtomicInteger retryAttempts = new AtomicInteger();
    private final Deque<Message> messageQueue = new ConcurrentLinkedDeque<Message>();
    private final AtomicBoolean linkCreditsAdded = new AtomicBoolean();
    private final AtomicReference<CoreSubscriber<? super Message>> downstream = new AtomicReference();
    private final AtomicInteger wip = new AtomicInteger();
    private final int prefetch;
    private final AmqpRetryPolicy retryPolicy;
    private final Disposable parentConnection;
    private volatile Throwable lastError;
    private volatile boolean isCancelled;
    private volatile AmqpReceiveLink currentLink;
    private volatile Disposable currentLinkSubscriptions;
    private volatile Disposable retrySubscription;
    private volatile Subscription upstream;
    private static final AtomicReferenceFieldUpdater<AmqpReceiveLinkProcessor, Subscription> UPSTREAM = AtomicReferenceFieldUpdater.newUpdater(AmqpReceiveLinkProcessor.class, Subscription.class, "upstream");
    private volatile long requested;
    private static final AtomicLongFieldUpdater<AmqpReceiveLinkProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(AmqpReceiveLinkProcessor.class, "requested");

    public AmqpReceiveLinkProcessor(int prefetch, AmqpRetryPolicy retryPolicy, Disposable parentConnection) {
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
        this.parentConnection = Objects.requireNonNull(parentConnection, "'parentConnection' cannot be null.");
        if (prefetch < 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'prefetch' cannot be less than 0."));
        }
        this.prefetch = prefetch;
    }

    public Throwable getError() {
        return this.lastError;
    }

    public boolean isTerminated() {
        return this.isTerminated.get() || this.isCancelled;
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "'subscription' cannot be null");
        this.logger.info("Setting new subscription for receive link processor");
        if (!Operators.setOnce(UPSTREAM, (Object)((Object)this), (Subscription)subscription)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot set upstream twice."));
        }
        this.requestUpstream();
    }

    public int getPrefetch() {
        return this.prefetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(AmqpReceiveLink next) {
        Disposable oldSubscription;
        AmqpReceiveLink oldChannel;
        Objects.requireNonNull(next, "'next' cannot be null.");
        if (this.isTerminated()) {
            this.logger.warning("linkName[{}] entityPath[{}]. Got another link when we have already terminated processor.", new Object[]{next.getLinkName(), next.getEntityPath()});
            Operators.onNextDropped((Object)next, (Context)this.currentContext());
            return;
        }
        String linkName = next.getLinkName();
        String entityPath = next.getEntityPath();
        this.logger.info("linkName[{}] entityPath[{}]. Setting next AMQP receive link.", new Object[]{linkName, entityPath});
        Object object = this.lock;
        synchronized (object) {
            oldChannel = this.currentLink;
            oldSubscription = this.currentLinkSubscriptions;
            this.currentLink = next;
            this.linkCreditsAdded.set(true);
            next.addCredits(this.prefetch);
            next.setEmptyCreditListener(this::getCreditsToAdd);
            this.currentLinkSubscriptions = Disposables.composite((Disposable[])new Disposable[]{next.getEndpointStates().subscribe(state -> {
                if (state == AmqpEndpointState.ACTIVE) {
                    this.logger.info("Link {} is now active with {} credits.", new Object[]{linkName, next.getCredits()});
                    this.retryAttempts.set(0);
                }
            }, error -> {
                this.currentLink = null;
                this.logger.warning("linkName[{}] entityPath[{}]. Error occurred in link.", new Object[]{linkName, entityPath});
                this.onError((Throwable)error);
            }, () -> {
                if (this.parentConnection.isDisposed() || this.isTerminated() || UPSTREAM.get(this) == Operators.cancelledSubscription()) {
                    this.logger.info("Terminal state reached. Disposing of link processor.");
                    this.dispose();
                } else {
                    this.logger.info("Receive link endpoint states are closed. Requesting another.");
                    AmqpReceiveLink existing = this.currentLink;
                    this.currentLink = null;
                    if (existing != null) {
                        existing.dispose();
                    }
                    this.requestUpstream();
                }
            }), next.receive().subscribe(message -> {
                this.messageQueue.add((Message)message);
                this.drain();
            })});
        }
        if (oldChannel != null) {
            oldChannel.dispose();
        }
        if (oldSubscription != null) {
            oldSubscription.dispose();
        }
    }

    public void subscribe(CoreSubscriber<? super Message> actual) {
        boolean terminateSubscriber;
        Objects.requireNonNull(actual, "'actual' cannot be null.");
        boolean bl = terminateSubscriber = this.isTerminated() || this.currentLink == null && this.upstream == Operators.cancelledSubscription();
        if (this.isTerminated()) {
            AmqpReceiveLink link = this.currentLink;
            String linkName = link != null ? link.getLinkName() : "n/a";
            String entityPath = link != null ? link.getEntityPath() : "n/a";
            this.logger.info("linkName[{}] entityPath[{}]. AmqpReceiveLink is already terminated.", new Object[]{linkName, entityPath});
        } else if (this.currentLink == null && this.upstream == Operators.cancelledSubscription()) {
            this.logger.info("There is no current link and upstream is terminated.");
        }
        if (terminateSubscriber) {
            actual.onSubscribe(Operators.emptySubscription());
            if (this.hasError()) {
                actual.onError(this.lastError);
            } else {
                actual.onComplete();
            }
            return;
        }
        if (this.downstream.compareAndSet(null, actual)) {
            actual.onSubscribe((Subscription)this);
            this.drain();
        } else {
            Operators.error(actual, (Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("There is already one downstream subscriber.'")));
        }
    }

    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable, "'throwable' is required.");
        this.logger.info("Error on receive link {}", new Object[]{this.currentLink, throwable});
        if (this.isTerminated() || this.isCancelled) {
            this.logger.info("AmqpReceiveLinkProcessor is terminated. Cannot process another error.", new Object[]{throwable});
            Operators.onErrorDropped((Throwable)throwable, (Context)this.currentContext());
            return;
        }
        if (this.parentConnection.isDisposed()) {
            this.logger.info("Parent connection is disposed. Not reopening on error.");
        }
        this.lastError = throwable;
        this.isTerminated.set(true);
        CoreSubscriber<? super Message> subscriber = this.downstream.get();
        if (subscriber != null) {
            subscriber.onError(throwable);
        }
        this.onDispose();
    }

    public void onComplete() {
        this.logger.info("Receive link completed {}", new Object[]{this.currentLink});
        UPSTREAM.set(this, Operators.cancelledSubscription());
    }

    public void dispose() {
        this.logger.info("Disposing receive link {}", new Object[]{this.currentLink});
        if (this.isTerminated.getAndSet(true)) {
            return;
        }
        this.drain();
        this.onDispose();
    }

    public void request(long request) {
        if (!Operators.validate((long)request)) {
            this.logger.warning("Invalid request: {}", new Object[]{request});
            return;
        }
        Operators.addCap(REQUESTED, (Object)((Object)this), (long)request);
        AmqpReceiveLink link = this.currentLink;
        if (link != null && !this.linkCreditsAdded.getAndSet(true)) {
            int credits = this.getCreditsToAdd();
            this.logger.verbose("Link credits not yet added. Adding: {}", new Object[]{credits});
            link.addCredits(credits);
        }
        this.drain();
    }

    public void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestUpstream() {
        if (this.isTerminated()) {
            this.logger.info("Processor is terminated. Not requesting another link.");
            return;
        }
        if (UPSTREAM.get(this) == null) {
            this.logger.info("There is no upstream. Not requesting another link.");
            return;
        }
        if (UPSTREAM.get(this) == Operators.cancelledSubscription()) {
            this.logger.info("Upstream is cancelled or complete. Not requesting another link.");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.currentLink != null) {
                this.logger.info("Current link exists. Not requesting another link.");
                return;
            }
        }
        this.logger.info("Requesting a new AmqpReceiveLink from upstream.");
        UPSTREAM.get(this).request(1L);
    }

    private void onDispose() {
        if (this.retrySubscription != null && !this.retrySubscription.isDisposed()) {
            this.retrySubscription.dispose();
        }
        if (this.currentLink != null) {
            this.currentLink.dispose();
        }
        this.currentLink = null;
        if (this.currentLinkSubscriptions != null) {
            this.currentLinkSubscriptions.dispose();
        }
        Operators.onDiscardQueueWithClear(this.messageQueue, (Context)this.currentContext(), null);
    }

    private void drain() {
        if (!this.wip.compareAndSet(0, 1)) {
            return;
        }
        try {
            this.drainQueue();
        }
        finally {
            if (this.wip.decrementAndGet() != 0) {
                this.logger.warning("There is another worker in drainLoop. But there should only be 1 worker.");
            }
        }
    }

    private void drainQueue() {
        CoreSubscriber<? super Message> subscriber = this.downstream.get();
        if (subscriber == null || this.checkAndSetTerminated()) {
            return;
        }
        long numberRequested = this.requested;
        boolean isEmpty = this.messageQueue.isEmpty();
        while (numberRequested != 0L && !isEmpty && !this.checkAndSetTerminated()) {
            Message message;
            long numberEmitted;
            for (numberEmitted = 0L; !(numberRequested == numberEmitted || isEmpty && this.checkAndSetTerminated() || (message = this.messageQueue.poll()) == null); ++numberEmitted) {
                if (this.isCancelled) {
                    Operators.onDiscard((Object)message, (Context)subscriber.currentContext());
                    Operators.onDiscardQueueWithClear(this.messageQueue, (Context)subscriber.currentContext(), null);
                    return;
                }
                try {
                    subscriber.onNext((Object)message);
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while handling downstream onNext operation.", new Object[]{e});
                    throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)Operators.onOperatorError((Subscription)this.upstream, (Throwable)e, (Object)message, (Context)subscriber.currentContext())));
                }
                isEmpty = this.messageQueue.isEmpty();
            }
            if (this.requested == Long.MAX_VALUE) continue;
            numberRequested = REQUESTED.addAndGet(this, -numberEmitted);
        }
    }

    private boolean checkAndSetTerminated() {
        if (!this.isTerminated()) {
            return false;
        }
        CoreSubscriber<? super Message> subscriber = this.downstream.get();
        Throwable error = this.lastError;
        if (error != null) {
            subscriber.onError(error);
        } else {
            subscriber.onComplete();
        }
        if (this.currentLink != null) {
            this.currentLink.dispose();
        }
        this.messageQueue.clear();
        return true;
    }

    private int getCreditsToAdd() {
        CoreSubscriber<? super Message> subscriber = this.downstream.get();
        long r = this.requested;
        if (subscriber == null || r == 0L) {
            this.logger.verbose("Not adding credits. No downstream subscribers or items requested.");
            this.linkCreditsAdded.set(false);
            return 0;
        }
        this.linkCreditsAdded.set(true);
        return r == Long.MAX_VALUE ? 1 : Long.valueOf(r).intValue();
    }
}

