/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpEndpointState;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.exception.OperationCancelledException;
import com.azure.core.amqp.implementation.AmqpEndpointStateUtil;
import com.azure.core.amqp.implementation.AmqpErrorCode;
import com.azure.core.amqp.implementation.AmqpSendLink;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.RetriableWorkItem;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.amqp.implementation.TokenManager;
import com.azure.core.amqp.implementation.handler.SendLinkHandler;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.Declared;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.ReplayProcessor;

class ReactorSender
implements AmqpSendLink {
    private final String entityPath;
    private final Sender sender;
    private final SendLinkHandler handler;
    private final ReactorProvider reactorProvider;
    private final Disposable.Composite subscriptions;
    private final AtomicBoolean hasConnected = new AtomicBoolean();
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final AtomicBoolean hasAuthorized = new AtomicBoolean(true);
    private final AtomicInteger retryAttempts = new AtomicInteger();
    private final Object pendingSendLock = new Object();
    private final ConcurrentHashMap<String, RetriableWorkItem> pendingSendsMap = new ConcurrentHashMap();
    private final PriorityQueue<WeightedDeliveryTag> pendingSendsQueue = new PriorityQueue<WeightedDeliveryTag>(1000, new DeliveryTagComparator());
    private final ClientLogger logger = new ClientLogger(ReactorSender.class);
    private final ReplayProcessor<AmqpEndpointState> endpointStates;
    private final TokenManager tokenManager;
    private final MessageSerializer messageSerializer;
    private final AmqpRetryPolicy retry;
    private final Duration timeout;
    private final Timer sendTimeoutTimer = new Timer("SendTimeout-timer");
    private final Object errorConditionLock = new Object();
    private volatile Exception lastKnownLinkError;
    private volatile Instant lastKnownErrorReportedAt;
    private volatile int linkSize;

    ReactorSender(String entityPath, Sender sender, SendLinkHandler handler, ReactorProvider reactorProvider, TokenManager tokenManager, MessageSerializer messageSerializer, Duration timeout, AmqpRetryPolicy retry) {
        this.entityPath = entityPath;
        this.sender = sender;
        this.handler = handler;
        this.reactorProvider = reactorProvider;
        this.tokenManager = tokenManager;
        this.messageSerializer = messageSerializer;
        this.retry = retry;
        this.timeout = timeout;
        this.endpointStates = (ReplayProcessor)this.handler.getEndpointStates().map(state -> {
            this.logger.verbose("connectionId[{}], path[{}], linkName[{}]: State {}", new Object[]{handler.getConnectionId(), entityPath, this.getLinkName(), state});
            this.hasConnected.set(state == EndpointState.ACTIVE);
            return AmqpEndpointStateUtil.getConnectionState(state);
        }).subscribeWith((Subscriber)ReplayProcessor.cacheLastOrDefault((Object)((Object)AmqpEndpointState.UNINITIALIZED)));
        this.subscriptions = Disposables.composite((Disposable[])new Disposable[]{this.handler.getDeliveredMessages().subscribe(this::processDeliveredMessage), this.handler.getLinkCredits().subscribe(credit -> {
            this.logger.verbose("connectionId[{}], entityPath[{}], linkName[{}]: Credits on link: {}", new Object[]{handler.getConnectionId(), entityPath, this.getLinkName(), credit});
            this.scheduleWorkOnDispatcher();
        })});
        if (tokenManager != null) {
            this.subscriptions.add(this.tokenManager.getAuthorizationResults().subscribe(response -> {
                this.logger.verbose("connectionId[{}], entityPath[{}], linkName[{}]: Token refreshed: {}", new Object[]{handler.getConnectionId(), entityPath, this.getLinkName(), response});
                this.hasAuthorized.set(true);
            }, error -> {
                this.logger.info("connectionId[{}], entityPath[{}], linkName[{}]: tokenRenewalFailure[{}]", new Object[]{handler.getConnectionId(), entityPath, this.getLinkName(), error.getMessage()});
                this.hasAuthorized.set(false);
            }, () -> this.hasAuthorized.set(false)));
        }
    }

    @Override
    public Flux<AmqpEndpointState> getEndpointStates() {
        return this.endpointStates;
    }

    @Override
    public Mono<Void> send(Message message) {
        return this.send(message, null);
    }

    @Override
    public Mono<Void> send(Message message, DeliveryState deliveryState) {
        return this.getLinkSize().flatMap(maxMessageSize -> {
            int encodedSize;
            int payloadSize = this.messageSerializer.getSize(message);
            int allocationSize = Math.min(payloadSize + 512, maxMessageSize);
            byte[] bytes = new byte[allocationSize];
            try {
                encodedSize = message.encode(bytes, 0, allocationSize);
            }
            catch (BufferOverflowException exception) {
                String errorMessage = String.format(Locale.US, "Error sending. Size of the payload exceeded maximum message size: %s kb", maxMessageSize / 1024);
                AmqpException error = new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, errorMessage, exception, this.handler.getErrorContext((Link)this.sender));
                return Mono.error((Throwable)((Object)error));
            }
            return this.send(bytes, encodedSize, 0, deliveryState);
        }).then();
    }

    @Override
    public Mono<Void> send(List<Message> messageBatch) {
        return this.send(messageBatch, null);
    }

    @Override
    public Mono<Void> send(List<Message> messageBatch, DeliveryState deliveryState) {
        if (messageBatch.size() == 1) {
            return this.send(messageBatch.get(0), deliveryState);
        }
        return this.getLinkSize().flatMap(maxMessageSize -> {
            int encodedSize;
            Message firstMessage = (Message)messageBatch.get(0);
            Message batchMessage = Proton.message();
            batchMessage.setMessageAnnotations(firstMessage.getMessageAnnotations());
            int maxMessageSizeTemp = maxMessageSize;
            byte[] bytes = new byte[maxMessageSizeTemp];
            int byteArrayOffset = encodedSize = batchMessage.encode(bytes, 0, maxMessageSizeTemp);
            for (Message amqpMessage : messageBatch) {
                Message messageWrappedByData = Proton.message();
                int payloadSize = this.messageSerializer.getSize(amqpMessage);
                int allocationSize = Math.min(payloadSize + 512, maxMessageSizeTemp);
                byte[] messageBytes = new byte[allocationSize];
                int messageSizeBytes = amqpMessage.encode(messageBytes, 0, allocationSize);
                messageWrappedByData.setBody((Section)new Data(new Binary(messageBytes, 0, messageSizeBytes)));
                try {
                    encodedSize = messageWrappedByData.encode(bytes, byteArrayOffset, maxMessageSizeTemp - byteArrayOffset - 1);
                }
                catch (BufferOverflowException exception) {
                    String message = String.format(Locale.US, "Size of the payload exceeded maximum message size: %s kb", maxMessageSizeTemp / 1024);
                    AmqpException error = new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, message, exception, this.handler.getErrorContext((Link)this.sender));
                    return Mono.error((Throwable)((Object)error));
                }
                byteArrayOffset += encodedSize;
            }
            return this.send(bytes, byteArrayOffset, -2147404032, deliveryState);
        }).then();
    }

    @Override
    public AmqpErrorContext getErrorContext() {
        return this.handler.getErrorContext((Link)this.sender);
    }

    @Override
    public String getLinkName() {
        return this.sender.getName();
    }

    @Override
    public String getEntityPath() {
        return this.entityPath;
    }

    @Override
    public String getHostname() {
        return this.handler.getHostname();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<Integer> getLinkSize() {
        if (this.linkSize > 0) {
            return Mono.just((Object)this.linkSize);
        }
        ReactorSender reactorSender = this;
        synchronized (reactorSender) {
            if (this.linkSize > 0) {
                return Mono.just((Object)this.linkSize);
            }
            return RetryUtil.withRetry(this.getEndpointStates().takeUntil(state -> state == AmqpEndpointState.ACTIVE).then(Mono.fromCallable(() -> {
                UnsignedLong remoteMaxMessageSize = this.sender.getRemoteMaxMessageSize();
                if (remoteMaxMessageSize != null) {
                    this.linkSize = remoteMaxMessageSize.intValue();
                }
                return this.linkSize;
            })), this.timeout, this.retry);
        }
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    public void dispose() {
        this.dispose(null);
    }

    void dispose(ErrorCondition errorCondition) {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.subscriptions.dispose();
        this.tokenManager.close();
        if (this.sender.getLocalState() == EndpointState.CLOSED) {
            return;
        }
        this.logger.verbose("connectionId[{}], path[{}], linkName[{}]: setting error condition {}", new Object[]{this.handler.getConnectionId(), this.entityPath, this.getLinkName(), errorCondition != null ? errorCondition : "n/a"});
        if (errorCondition != null && this.sender.getCondition() == null) {
            this.sender.setCondition(errorCondition);
        }
        this.sender.close();
    }

    @Override
    public Mono<DeliveryState> send(byte[] bytes, int arrayOffset, int messageFormat, DeliveryState deliveryState) {
        return this.validateEndpoint().then(Mono.create(sink -> this.sendWork(new RetriableWorkItem(bytes, arrayOffset, messageFormat, (MonoSink<DeliveryState>)sink, this.timeout, deliveryState))));
    }

    private Mono<Void> validateEndpoint() {
        return Mono.defer(() -> RetryUtil.withRetry(this.handler.getEndpointStates().takeUntil(state -> state == EndpointState.ACTIVE), this.timeout, this.retry).then());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWork(RetriableWorkItem workItem) {
        String deliveryTag = UUID.randomUUID().toString().replace("-", "");
        Object object = this.pendingSendLock;
        synchronized (object) {
            this.pendingSendsMap.put(deliveryTag, workItem);
            this.pendingSendsQueue.offer(new WeightedDeliveryTag(deliveryTag, workItem.hasBeenRetried() ? 1 : 0));
        }
        this.scheduleWorkOnDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSendWork() {
        if (!this.hasConnected.get()) {
            this.logger.warning("Not connected. Not processing send work.");
            return;
        }
        while (this.hasConnected.get() && this.sender.getCredit() > 0) {
            RetriableWorkItem workItem;
            String deliveryTag;
            Object object = this.pendingSendLock;
            synchronized (object) {
                WeightedDeliveryTag weightedDelivery = this.pendingSendsQueue.poll();
                if (weightedDelivery != null) {
                    deliveryTag = weightedDelivery.getDeliveryTag();
                    workItem = this.pendingSendsMap.get(deliveryTag);
                } else {
                    workItem = null;
                    deliveryTag = null;
                }
            }
            if (workItem == null) {
                if (deliveryTag == null) break;
                this.logger.verbose("clientId[{}]. path[{}], linkName[{}], deliveryTag[{}]: sendData not found for this delivery.", new Object[]{this.handler.getConnectionId(), this.entityPath, this.getLinkName(), deliveryTag});
                break;
            }
            Delivery delivery = null;
            boolean linkAdvance = false;
            int sentMsgSize = 0;
            Exception sendException = null;
            try {
                delivery = this.sender.delivery(deliveryTag.getBytes(StandardCharsets.UTF_8));
                delivery.setMessageFormat(workItem.getMessageFormat());
                if (workItem.isDeliveryStateProvided()) {
                    delivery.disposition(workItem.getDeliveryState());
                }
                sentMsgSize = this.sender.send(workItem.getMessage(), 0, workItem.getEncodedMessageSize());
                assert (sentMsgSize == workItem.getEncodedMessageSize()) : "Contract of the ProtonJ library for Sender. Send API changed";
                linkAdvance = this.sender.advance();
            }
            catch (Exception exception) {
                sendException = exception;
            }
            if (linkAdvance) {
                this.logger.verbose("entityPath[{}], linkName[{}], deliveryTag[{}]: Sent message", new Object[]{this.entityPath, this.getLinkName(), deliveryTag});
                workItem.setWaitingForAck();
                this.sendTimeoutTimer.schedule((TimerTask)new SendTimeout(deliveryTag), this.timeout.toMillis());
                continue;
            }
            this.logger.verbose("clientId[{}]. path[{}], linkName[{}], deliveryTag[{}], sentMessageSize[{}], payloadActualSize[{}]: sendlink advance failed", new Object[]{this.handler.getConnectionId(), this.entityPath, this.getLinkName(), deliveryTag, sentMsgSize, workItem.getEncodedMessageSize()});
            if (delivery != null) {
                delivery.free();
            }
            AmqpErrorContext context = this.handler.getErrorContext((Link)this.sender);
            OperationCancelledException exception = sendException != null ? new OperationCancelledException(String.format(Locale.US, "Entity(%s): send operation failed. Please see cause for more details", this.entityPath), sendException, context) : new OperationCancelledException(String.format(Locale.US, "Entity(%s): send operation failed while advancing delivery(tag: %s).", this.entityPath, deliveryTag), context);
            workItem.error((Throwable)((Object)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeliveredMessage(Delivery delivery) {
        DeliveryState outcome = delivery.getRemoteState();
        String deliveryTag = new String(delivery.getTag(), StandardCharsets.UTF_8);
        this.logger.verbose("entityPath[{}], linkName[{}], deliveryTag[{}]: process delivered message", new Object[]{this.entityPath, this.getLinkName(), deliveryTag});
        RetriableWorkItem workItem = this.pendingSendsMap.remove(deliveryTag);
        if (workItem == null) {
            this.logger.verbose("clientId[{}]. path[{}], linkName[{}], delivery[{}] - mismatch (or send timed out)", new Object[]{this.handler.getConnectionId(), this.entityPath, this.getLinkName(), deliveryTag});
            return;
        }
        if (workItem.isDeliveryStateProvided()) {
            workItem.success(outcome);
            return;
        }
        if (outcome instanceof Accepted) {
            Object object = this.errorConditionLock;
            synchronized (object) {
                this.lastKnownLinkError = null;
                this.lastKnownErrorReportedAt = null;
                this.retryAttempts.set(0);
            }
            workItem.success(outcome);
        } else if (outcome instanceof Rejected) {
            Duration retryInterval;
            int retryAttempt;
            Rejected rejected = (Rejected)outcome;
            ErrorCondition error = rejected.getError();
            Exception exception = ExceptionUtil.toException(error.getCondition().toString(), error.getDescription(), this.handler.getErrorContext((Link)this.sender));
            this.logger.warning("entityPath[{}], linkName[{}], deliveryTag[{}]: Delivery rejected. [{}]", new Object[]{this.entityPath, this.getLinkName(), deliveryTag, rejected});
            if (ReactorSender.isGeneralSendError(error.getCondition())) {
                Object object = this.errorConditionLock;
                synchronized (object) {
                    this.lastKnownLinkError = exception;
                    this.lastKnownErrorReportedAt = Instant.now();
                    retryAttempt = this.retryAttempts.incrementAndGet();
                }
            } else {
                retryAttempt = this.retryAttempts.get();
            }
            if ((retryInterval = this.retry.calculateRetryDelay(exception, retryAttempt)) == null || retryInterval.compareTo(workItem.getTimeoutTracker().remaining()) > 0) {
                this.cleanupFailedSend(workItem, exception);
            } else {
                workItem.setLastKnownException(exception);
                try {
                    this.reactorProvider.getReactorDispatcher().invoke(() -> this.sendWork(workItem), retryInterval);
                }
                catch (IOException | RejectedExecutionException schedulerException) {
                    exception.initCause(schedulerException);
                    this.cleanupFailedSend(workItem, (Exception)((Object)new AmqpException(false, String.format(Locale.US, "Entity(%s): send operation failed while scheduling a retry on Reactor, see cause for more details.", this.entityPath), (Throwable)schedulerException, this.handler.getErrorContext((Link)this.sender))));
                }
            }
        } else if (outcome instanceof Released) {
            this.cleanupFailedSend(workItem, (Exception)((Object)new OperationCancelledException(outcome.toString(), this.handler.getErrorContext((Link)this.sender))));
        } else if (outcome instanceof Declared) {
            Declared declared = (Declared)outcome;
            workItem.success((DeliveryState)declared);
        } else {
            this.cleanupFailedSend(workItem, (Exception)((Object)new AmqpException(false, outcome.toString(), this.handler.getErrorContext((Link)this.sender))));
        }
    }

    private void scheduleWorkOnDispatcher() {
        try {
            this.reactorProvider.getReactorDispatcher().invoke(this::processSendWork);
        }
        catch (IOException e) {
            this.logger.error("Error scheduling work on reactor.", new Object[]{e});
        }
    }

    private void cleanupFailedSend(RetriableWorkItem workItem, Exception exception) {
        workItem.error(exception);
    }

    private static boolean isGeneralSendError(Symbol amqpError) {
        return amqpError == AmqpErrorCode.SERVER_BUSY_ERROR || amqpError == AmqpErrorCode.TIMEOUT_ERROR || amqpError == AmqpErrorCode.RESOURCE_LIMIT_EXCEEDED;
    }

    private class SendTimeout
    extends TimerTask {
        private final String deliveryTag;

        SendTimeout(String deliveryTag) {
            this.deliveryTag = deliveryTag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Instant lastErrorTime;
            Exception lastError;
            RetriableWorkItem workItem = (RetriableWorkItem)ReactorSender.this.pendingSendsMap.remove(this.deliveryTag);
            if (workItem == null) {
                return;
            }
            Exception cause = ReactorSender.this.lastKnownLinkError;
            Object object = ReactorSender.this.errorConditionLock;
            synchronized (object) {
                lastError = ReactorSender.this.lastKnownLinkError;
                lastErrorTime = ReactorSender.this.lastKnownErrorReportedAt;
            }
            if (lastError != null && lastErrorTime != null) {
                Instant now = Instant.now();
                boolean isLastErrorAfterSleepTime = lastErrorTime.isAfter(now.minusSeconds(4L));
                boolean isServerBusy = lastError instanceof AmqpException && isLastErrorAfterSleepTime;
                boolean isLastErrorAfterOperationTimeout = lastErrorTime.isAfter(now.minus(ReactorSender.this.timeout));
                cause = isServerBusy || isLastErrorAfterOperationTimeout ? lastError : null;
            }
            AmqpException exception = cause instanceof AmqpException ? (AmqpException)((Object)cause) : new AmqpException(true, AmqpErrorCondition.TIMEOUT_ERROR, String.format(Locale.US, "Entity(%s): Send operation timed out", ReactorSender.this.entityPath), ReactorSender.this.handler.getErrorContext((Link)ReactorSender.this.sender));
            workItem.error((Throwable)((Object)exception));
        }
    }

    private static class DeliveryTagComparator
    implements Comparator<WeightedDeliveryTag>,
    Serializable {
        private static final long serialVersionUID = -7057500582037295635L;

        private DeliveryTagComparator() {
        }

        @Override
        public int compare(WeightedDeliveryTag deliveryTag0, WeightedDeliveryTag deliveryTag1) {
            return deliveryTag1.getPriority() - deliveryTag0.getPriority();
        }
    }

    private static class WeightedDeliveryTag {
        private final String deliveryTag;
        private final int priority;

        WeightedDeliveryTag(String deliveryTag, int priority) {
            this.deliveryTag = deliveryTag;
            this.priority = priority;
        }

        private String getDeliveryTag() {
            return this.deliveryTag;
        }

        private int getPriority() {
            return this.priority;
        }
    }
}

