/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.azure.eventhubs.EventHubsComponent;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class EventHubsComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private EventHubsConfiguration getOrCreateConfiguration(EventHubsComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new EventHubsConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        EventHubsComponent target = (EventHubsComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "amqpretryoptions": 
            case "amqpRetryOptions": {
                this.getOrCreateConfiguration(target).setAmqpRetryOptions((AmqpRetryOptions)EventHubsComponentConfigurer.property((CamelContext)camelContext, AmqpRetryOptions.class, (Object)value));
                return true;
            }
            case "amqptransporttype": 
            case "amqpTransportType": {
                this.getOrCreateConfiguration(target).setAmqpTransportType((AmqpTransportType)EventHubsComponentConfigurer.property((CamelContext)camelContext, AmqpTransportType.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)EventHubsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)EventHubsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "blobaccesskey": 
            case "blobAccessKey": {
                this.getOrCreateConfiguration(target).setBlobAccessKey((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "blobaccountname": 
            case "blobAccountName": {
                this.getOrCreateConfiguration(target).setBlobAccountName((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "blobcontainername": 
            case "blobContainerName": {
                this.getOrCreateConfiguration(target).setBlobContainerName((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "blobstoragesharedkeycredential": 
            case "blobStorageSharedKeyCredential": {
                this.getOrCreateConfiguration(target).setBlobStorageSharedKeyCredential((StorageSharedKeyCredential)EventHubsComponentConfigurer.property((CamelContext)camelContext, StorageSharedKeyCredential.class, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)EventHubsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "checkpointstore": 
            case "checkpointStore": {
                this.getOrCreateConfiguration(target).setCheckpointStore((CheckpointStore)EventHubsComponentConfigurer.property((CamelContext)camelContext, CheckpointStore.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((EventHubsConfiguration)EventHubsComponentConfigurer.property((CamelContext)camelContext, EventHubsConfiguration.class, (Object)value));
                return true;
            }
            case "connectionstring": 
            case "connectionString": {
                this.getOrCreateConfiguration(target).setConnectionString((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumergroupname": 
            case "consumerGroupName": {
                this.getOrCreateConfiguration(target).setConsumerGroupName((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "eventposition": 
            case "eventPosition": {
                this.getOrCreateConfiguration(target).setEventPosition((Map)EventHubsComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)EventHubsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "partitionid": 
            case "partitionId": {
                this.getOrCreateConfiguration(target).setPartitionId((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "partitionkey": 
            case "partitionKey": {
                this.getOrCreateConfiguration(target).setPartitionKey((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prefetchcount": 
            case "prefetchCount": {
                this.getOrCreateConfiguration(target).setPrefetchCount((Integer)EventHubsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "producerasyncclient": 
            case "producerAsyncClient": {
                this.getOrCreateConfiguration(target).setProducerAsyncClient((EventHubProducerAsyncClient)EventHubsComponentConfigurer.property((CamelContext)camelContext, EventHubProducerAsyncClient.class, (Object)value));
                return true;
            }
            case "sharedaccesskey": 
            case "sharedAccessKey": {
                this.getOrCreateConfiguration(target).setSharedAccessKey((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sharedaccessname": 
            case "sharedAccessName": {
                this.getOrCreateConfiguration(target).setSharedAccessName((String)EventHubsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        EventHubsComponent target = (EventHubsComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "amqpretryoptions": 
            case "amqpRetryOptions": {
                return this.getOrCreateConfiguration(target).getAmqpRetryOptions();
            }
            case "amqptransporttype": 
            case "amqpTransportType": {
                return this.getOrCreateConfiguration(target).getAmqpTransportType();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "blobaccesskey": 
            case "blobAccessKey": {
                return this.getOrCreateConfiguration(target).getBlobAccessKey();
            }
            case "blobaccountname": 
            case "blobAccountName": {
                return this.getOrCreateConfiguration(target).getBlobAccountName();
            }
            case "blobcontainername": 
            case "blobContainerName": {
                return this.getOrCreateConfiguration(target).getBlobContainerName();
            }
            case "blobstoragesharedkeycredential": 
            case "blobStorageSharedKeyCredential": {
                return this.getOrCreateConfiguration(target).getBlobStorageSharedKeyCredential();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "checkpointstore": 
            case "checkpointStore": {
                return this.getOrCreateConfiguration(target).getCheckpointStore();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connectionstring": 
            case "connectionString": {
                return this.getOrCreateConfiguration(target).getConnectionString();
            }
            case "consumergroupname": 
            case "consumerGroupName": {
                return this.getOrCreateConfiguration(target).getConsumerGroupName();
            }
            case "eventposition": 
            case "eventPosition": {
                return this.getOrCreateConfiguration(target).getEventPosition();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "partitionid": 
            case "partitionId": {
                return this.getOrCreateConfiguration(target).getPartitionId();
            }
            case "partitionkey": 
            case "partitionKey": {
                return this.getOrCreateConfiguration(target).getPartitionKey();
            }
            case "prefetchcount": 
            case "prefetchCount": {
                return this.getOrCreateConfiguration(target).getPrefetchCount();
            }
            case "producerasyncclient": 
            case "producerAsyncClient": {
                return this.getOrCreateConfiguration(target).getProducerAsyncClient();
            }
            case "sharedaccesskey": 
            case "sharedAccessKey": {
                return this.getOrCreateConfiguration(target).getSharedAccessKey();
            }
            case "sharedaccessname": 
            case "sharedAccessName": {
                return this.getOrCreateConfiguration(target).getSharedAccessName();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("amqpRetryOptions", AmqpRetryOptions.class);
        map.put("amqpTransportType", AmqpTransportType.class);
        map.put("autoDiscoverClient", Boolean.TYPE);
        map.put("configuration", EventHubsConfiguration.class);
        map.put("blobAccessKey", String.class);
        map.put("blobAccountName", String.class);
        map.put("blobContainerName", String.class);
        map.put("blobStorageSharedKeyCredential", StorageSharedKeyCredential.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("checkpointStore", CheckpointStore.class);
        map.put("consumerGroupName", String.class);
        map.put("eventPosition", Map.class);
        map.put("prefetchCount", Integer.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("partitionId", String.class);
        map.put("partitionKey", String.class);
        map.put("producerAsyncClient", EventHubProducerAsyncClient.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("connectionString", String.class);
        map.put("sharedAccessKey", String.class);
        map.put("sharedAccessName", String.class);
        ALL_OPTIONS = map;
    }
}

