/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.ClaimsBasedSecurityNode;
import com.azure.core.amqp.implementation.ActiveClientTokenManager;
import com.azure.core.amqp.implementation.CbsAuthorizationType;
import com.azure.core.amqp.implementation.TokenManager;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.util.logging.ClientLogger;
import java.util.Locale;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class AzureTokenManagerProvider
implements TokenManagerProvider {
    static final String TOKEN_AUDIENCE_FORMAT = "amqp://%s/%s";
    private final ClientLogger logger = new ClientLogger(AzureTokenManagerProvider.class);
    private final CbsAuthorizationType authorizationType;
    private final String fullyQualifiedNamespace;
    private final String activeDirectoryScope;

    public AzureTokenManagerProvider(CbsAuthorizationType authorizationType, String fullyQualifiedNamespace, String activeDirectoryScope) {
        this.activeDirectoryScope = Objects.requireNonNull(activeDirectoryScope, "'activeDirectoryScope' cannot be null.");
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.authorizationType = Objects.requireNonNull(authorizationType, "'authorizationType' cannot be null.");
    }

    @Override
    public TokenManager getTokenManager(Mono<ClaimsBasedSecurityNode> cbsNodeMono, String resource) {
        String scopes = this.getScopesFromResource(resource);
        String tokenAudience = String.format(Locale.US, TOKEN_AUDIENCE_FORMAT, this.fullyQualifiedNamespace, resource);
        this.logger.info("Creating new token manager for audience[{}], resource[{}]", new Object[]{tokenAudience, resource});
        return new ActiveClientTokenManager(cbsNodeMono, tokenAudience, scopes);
    }

    @Override
    public String getScopesFromResource(String resource) {
        switch (this.authorizationType) {
            case JSON_WEB_TOKEN: {
                return this.activeDirectoryScope;
            }
            case SHARED_ACCESS_SIGNATURE: {
                return String.format(Locale.US, TOKEN_AUDIENCE_FORMAT, this.fullyQualifiedNamespace, resource);
            }
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "'%s' is not supported authorization type for token audience.", new Object[]{this.authorizationType})));
    }
}

