/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import com.azure.core.amqp.AmqpRetryMode;
import java.time.Duration;
import java.util.Objects;

public class AmqpRetryOptions {
    private int maxRetries;
    private Duration delay;
    private Duration maxDelay;
    private Duration tryTimeout;
    private AmqpRetryMode retryMode;

    public AmqpRetryOptions() {
        this.maxRetries = 3;
        this.delay = Duration.ofMillis(800L);
        this.maxDelay = Duration.ofMinutes(1L);
        this.tryTimeout = Duration.ofMinutes(1L);
        this.retryMode = AmqpRetryMode.EXPONENTIAL;
    }

    public AmqpRetryOptions(AmqpRetryOptions retryOptions) {
        this.maxDelay = retryOptions.getMaxDelay();
        this.delay = retryOptions.getDelay();
        this.maxRetries = retryOptions.getMaxRetries();
        this.retryMode = retryOptions.getMode();
        this.tryTimeout = retryOptions.getTryTimeout();
    }

    public AmqpRetryOptions setMode(AmqpRetryMode retryMode) {
        this.retryMode = retryMode;
        return this;
    }

    public AmqpRetryOptions setMaxRetries(int numberOfRetries) {
        this.maxRetries = numberOfRetries;
        return this;
    }

    public AmqpRetryOptions setDelay(Duration delay) {
        this.delay = delay;
        return this;
    }

    public AmqpRetryOptions setMaxDelay(Duration maximumDelay) {
        this.maxDelay = maximumDelay;
        return this;
    }

    public AmqpRetryOptions setTryTimeout(Duration tryTimeout) {
        this.tryTimeout = tryTimeout;
        return this;
    }

    public AmqpRetryMode getMode() {
        return this.retryMode;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getTryTimeout() {
        return this.tryTimeout;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AmqpRetryOptions)) {
            return false;
        }
        AmqpRetryOptions other = (AmqpRetryOptions)obj;
        return this.getMaxRetries() == other.getMaxRetries() && this.getMode() == other.getMode() && Objects.equals(this.getMaxDelay(), other.getMaxDelay()) && Objects.equals(this.getDelay(), other.getDelay()) && Objects.equals(this.getTryTimeout(), other.getTryTimeout());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxRetries, this.retryMode, this.maxDelay, this.delay, this.tryTimeout});
    }
}

