/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common;

import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class StorageInputStream
extends InputStream {
    private static final String MARK_EXPIRED = "Stream mark expired.";
    private static final String UNEXPECTED_STREAM_READ_ERROR = "Unexpected error. Stream returned unexpected number of bytes.";
    private final ClientLogger logger = new ClientLogger(StorageInputStream.class);
    protected volatile boolean streamFaulted;
    protected IOException lastError;
    private ByteBuffer currentBuffer;
    private long markedPosition;
    private int markExpiry;
    private long currentAbsoluteReadPosition;
    protected long bufferStartOffset;
    protected int bufferSize;
    private final long rangeOffset;
    private final int chunkSize;
    private final long streamLength;

    protected StorageInputStream(int chunkSize, long contentLength) {
        this(0L, null, chunkSize, contentLength);
    }

    protected StorageInputStream(long rangeOffset, Long rangeLength, int chunkSize, long contentLength) {
        this.rangeOffset = rangeOffset;
        this.streamFaulted = false;
        this.currentAbsoluteReadPosition = rangeOffset;
        this.chunkSize = chunkSize;
        long l = this.streamLength = rangeLength == null ? contentLength - this.rangeOffset : Math.min(contentLength - this.rangeOffset, rangeLength);
        if (rangeOffset < 0L || rangeLength != null && rangeLength <= 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException());
        }
        this.reposition(rangeOffset);
    }

    @Override
    public synchronized int available() {
        return this.bufferSize - (int)(this.currentAbsoluteReadPosition - this.bufferStartOffset);
    }

    private synchronized void checkStreamState() {
        if (this.streamFaulted) {
            throw this.logger.logExceptionAsError(new RuntimeException(this.lastError.getMessage()));
        }
    }

    @Override
    public synchronized void close() {
        this.currentBuffer = null;
        this.streamFaulted = true;
        this.lastError = new IOException("Stream is already closed.");
    }

    protected abstract ByteBuffer dispatchRead(int var1, long var2) throws IOException;

    @Override
    public synchronized void mark(int readlimit) {
        this.markedPosition = this.currentAbsoluteReadPosition;
        this.markExpiry = readlimit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        byte[] tBuff = new byte[1];
        int numberOfBytesRead = this.read(tBuff, 0, 1);
        if (numberOfBytesRead > 0) {
            return tBuff[0] & 0xFF;
        }
        if (numberOfBytesRead == 0) {
            throw this.logger.logExceptionAsError(new RuntimeException(UNEXPECTED_STREAM_READ_ERROR));
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw this.logger.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException());
        }
        int chunks = (int)Math.ceil((double)len / (double)this.chunkSize);
        int numOfBytesRead = 0;
        for (int i = 0; i < chunks; ++i) {
            int results = this.readInternal(b, off + numOfBytesRead, len - numOfBytesRead);
            if (results == -1) {
                return -1;
            }
            numOfBytesRead += results;
        }
        return numOfBytesRead;
    }

    private synchronized int readInternal(byte[] b, int off, int len) throws IOException {
        int numberOfBytesRead;
        this.checkStreamState();
        if ((this.currentBuffer == null || this.currentBuffer.remaining() == 0) && this.currentAbsoluteReadPosition < this.streamLength + this.rangeOffset) {
            this.currentBuffer = this.dispatchRead((int)Math.min((long)this.chunkSize, this.streamLength + this.rangeOffset - this.currentAbsoluteReadPosition), this.currentAbsoluteReadPosition);
        }
        len = Math.min(len, this.chunkSize);
        if (this.currentBuffer.remaining() == 0) {
            numberOfBytesRead = -1;
        } else {
            numberOfBytesRead = Math.min(len, this.currentBuffer.remaining());
            this.currentBuffer = this.currentBuffer.get(b, off, numberOfBytesRead);
        }
        if (numberOfBytesRead > 0) {
            this.currentAbsoluteReadPosition += (long)numberOfBytesRead;
        }
        if (this.markExpiry > 0 && this.markedPosition + (long)this.markExpiry < this.currentAbsoluteReadPosition) {
            this.markedPosition = this.rangeOffset;
            this.markExpiry = 0;
        }
        return numberOfBytesRead;
    }

    private synchronized void reposition(long absolutePosition) {
        this.currentAbsoluteReadPosition = absolutePosition;
        this.currentBuffer = ByteBuffer.allocate(0);
        this.bufferStartOffset = absolutePosition;
    }

    @Override
    public synchronized void reset() {
        if (this.markedPosition + (long)this.markExpiry < this.currentAbsoluteReadPosition) {
            throw this.logger.logExceptionAsError(new RuntimeException(MARK_EXPIRED));
        }
        this.reposition(this.markedPosition);
    }

    @Override
    public synchronized long skip(long n) {
        if (n == 0L) {
            return 0L;
        }
        if (n < 0L || this.currentAbsoluteReadPosition + n > this.streamLength + this.rangeOffset) {
            throw this.logger.logExceptionAsError((RuntimeException)new IndexOutOfBoundsException());
        }
        this.reposition(this.currentAbsoluteReadPosition + n);
        return n;
    }
}

