/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common;

import com.azure.storage.common.ProgressReceiver;
import com.azure.storage.common.implementation.StorageImplUtils;

public final class ParallelTransferOptions {
    private final Integer blockSize;
    private final Integer maxConcurrency;
    private final ProgressReceiver progressReceiver;
    private final Integer maxSingleUploadSize;

    public ParallelTransferOptions(Integer blockSize, Integer maxConcurrency, ProgressReceiver progressReceiver, Integer maxSingleUploadSize) {
        this.blockSize = blockSize;
        this.maxConcurrency = maxConcurrency;
        if (maxConcurrency != null) {
            StorageImplUtils.assertInBounds("maxConcurrency", maxConcurrency.intValue(), 1L, Integer.MAX_VALUE);
        }
        this.progressReceiver = progressReceiver;
        this.maxSingleUploadSize = maxSingleUploadSize;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    @Deprecated
    public Integer getNumBuffers() {
        return this.maxConcurrency;
    }

    public ProgressReceiver getProgressReceiver() {
        return this.progressReceiver;
    }

    public Integer getMaxSingleUploadSize() {
        return this.maxSingleUploadSize;
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }
}

