/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.amqp.implementation.StringUtil;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.EventHubPartitionAsyncConsumer;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.implementation.AmqpReceiveLinkProcessor;
import com.azure.messaging.eventhubs.implementation.EventHubConnectionProcessor;
import com.azure.messaging.eventhubs.implementation.EventHubManagementNode;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.messaging.eventhubs.models.PartitionEvent;
import com.azure.messaging.eventhubs.models.ReceiveOptions;
import java.io.Closeable;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;

public class EventHubConsumerAsyncClient
implements Closeable {
    private static final String RECEIVER_ENTITY_PATH_FORMAT = "%s/ConsumerGroups/%s/Partitions/%s";
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final ReceiveOptions defaultReceiveOptions = new ReceiveOptions();
    private final ClientLogger logger = new ClientLogger(EventHubConsumerAsyncClient.class);
    private final String fullyQualifiedNamespace;
    private final String eventHubName;
    private final EventHubConnectionProcessor connectionProcessor;
    private final MessageSerializer messageSerializer;
    private final String consumerGroup;
    private final int prefetchCount;
    private final Scheduler scheduler;
    private final boolean isSharedConnection;
    private final Runnable onClientClosed;
    private final ConcurrentHashMap<String, EventHubPartitionAsyncConsumer> openPartitionConsumers = new ConcurrentHashMap();

    EventHubConsumerAsyncClient(String fullyQualifiedNamespace, String eventHubName, EventHubConnectionProcessor connectionProcessor, MessageSerializer messageSerializer, String consumerGroup, int prefetchCount, Scheduler scheduler, boolean isSharedConnection, Runnable onClientClosed) {
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
        this.eventHubName = eventHubName;
        this.connectionProcessor = connectionProcessor;
        this.messageSerializer = messageSerializer;
        this.consumerGroup = consumerGroup;
        this.prefetchCount = prefetchCount;
        this.scheduler = scheduler;
        this.isSharedConnection = isSharedConnection;
        this.onClientClosed = onClientClosed;
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public Mono<EventHubProperties> getEventHubProperties() {
        return this.connectionProcessor.flatMap(connection -> connection.getManagementNode()).flatMap(EventHubManagementNode::getEventHubProperties);
    }

    public Flux<String> getPartitionIds() {
        return this.getEventHubProperties().flatMapMany(properties -> Flux.fromIterable(properties.getPartitionIds()));
    }

    public Mono<PartitionProperties> getPartitionProperties(String partitionId) {
        if (Objects.isNull(partitionId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'partitionId' cannot be null."));
        }
        if (partitionId.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'partitionId' cannot be an empty string."));
        }
        return this.connectionProcessor.flatMap(connection -> connection.getManagementNode()).flatMap(node -> node.getPartitionProperties(partitionId));
    }

    public Flux<PartitionEvent> receiveFromPartition(String partitionId, EventPosition startingPosition) {
        return this.receiveFromPartition(partitionId, startingPosition, this.defaultReceiveOptions);
    }

    public Flux<PartitionEvent> receiveFromPartition(String partitionId, EventPosition startingPosition, ReceiveOptions receiveOptions) {
        if (Objects.isNull(partitionId)) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'partitionId' cannot be null."));
        }
        if (partitionId.isEmpty()) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'partitionId' cannot be an empty string."));
        }
        if (Objects.isNull(startingPosition)) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'startingPosition' cannot be null."));
        }
        String linkName = StringUtil.getRandomString((String)partitionId);
        return this.createConsumer(linkName, partitionId, startingPosition, receiveOptions);
    }

    public Flux<PartitionEvent> receive() {
        return this.receive(true, this.defaultReceiveOptions);
    }

    public Flux<PartitionEvent> receive(boolean startReadingAtEarliestEvent) {
        return this.receive(startReadingAtEarliestEvent, this.defaultReceiveOptions);
    }

    public Flux<PartitionEvent> receive(boolean startReadingAtEarliestEvent, ReceiveOptions receiveOptions) {
        if (Objects.isNull(receiveOptions)) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'receiveOptions' cannot be null."));
        }
        EventPosition startingPosition = startReadingAtEarliestEvent ? EventPosition.earliest() : EventPosition.latest();
        String prefix = StringUtil.getRandomString((String)"all");
        Flux allPartitionEvents = this.getPartitionIds().flatMap(partitionId -> {
            String linkName = prefix + "-" + partitionId;
            return this.createConsumer(linkName, (String)partitionId, startingPosition, receiveOptions);
        });
        return Flux.merge((Publisher[])new Publisher[]{allPartitionEvents});
    }

    @Override
    public void close() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.openPartitionConsumers.forEach((key, value) -> value.close());
        this.openPartitionConsumers.clear();
        if (this.isSharedConnection) {
            this.onClientClosed.run();
        } else {
            this.connectionProcessor.dispose();
        }
    }

    private Flux<PartitionEvent> createConsumer(String linkName, String partitionId, EventPosition startingPosition, ReceiveOptions receiveOptions) {
        return this.openPartitionConsumers.computeIfAbsent(linkName, name -> this.createPartitionConsumer((String)name, partitionId, startingPosition, receiveOptions)).receive().doFinally(signal -> this.removeLink(linkName, partitionId, (SignalType)signal));
    }

    private void removeLink(String linkName, String partitionId, SignalType signalType) {
        this.logger.info("linkName[{}], partitionId[{}], signal[{}]: Receiving completed.", new Object[]{linkName, partitionId, signalType});
        EventHubPartitionAsyncConsumer consumer = this.openPartitionConsumers.remove(linkName);
        if (consumer != null) {
            consumer.close();
        }
    }

    private EventHubPartitionAsyncConsumer createPartitionConsumer(String linkName, String partitionId, EventPosition startingPosition, ReceiveOptions receiveOptions) {
        String entityPath = String.format(Locale.US, RECEIVER_ENTITY_PATH_FORMAT, this.getEventHubName(), this.consumerGroup, partitionId);
        AtomicReference<Supplier<EventPosition>> initialPosition = new AtomicReference<Supplier<EventPosition>>(() -> startingPosition);
        Flux receiveLinkMono = this.connectionProcessor.flatMap(connection -> {
            this.logger.info("connectionId[{}] linkName[{}]: Creating receive consumer for partition '{}'", new Object[]{connection.getId(), linkName, partitionId});
            return connection.createReceiveLink(linkName, entityPath, (EventPosition)((Supplier)initialPosition.get()).get(), receiveOptions);
        }).repeat();
        AmqpRetryPolicy retryPolicy = RetryUtil.getRetryPolicy((AmqpRetryOptions)this.connectionProcessor.getRetryOptions());
        AmqpReceiveLinkProcessor linkMessageProcessor = (AmqpReceiveLinkProcessor)receiveLinkMono.subscribeWith((Subscriber)new AmqpReceiveLinkProcessor(this.prefetchCount, retryPolicy, (Disposable)this.connectionProcessor));
        return new EventHubPartitionAsyncConsumer(linkMessageProcessor, this.messageSerializer, this.getFullyQualifiedNamespace(), this.getEventHubName(), this.consumerGroup, partitionId, initialPosition, receiveOptions.getTrackLastEnqueuedEventProperties(), this.scheduler);
    }
}

