/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.azurecosmosdb;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAzurecosmosdbSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_AZURECOSMOSDB_PATH_DATABASE_NAME_CONF = "camel.sink.path.databaseName";
    public static final String CAMEL_SINK_AZURECOSMOSDB_PATH_DATABASE_NAME_DOC = "The name of the Cosmos database that component should connect to. In case you are producing data and have createDatabaseIfNotExists=true, the component will automatically auto create a Cosmos database.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_PATH_DATABASE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_PATH_CONTAINER_NAME_CONF = "camel.sink.path.containerName";
    public static final String CAMEL_SINK_AZURECOSMOSDB_PATH_CONTAINER_NAME_DOC = "The name of the Cosmos container that component should connect to. In case you are producing data and have createContainerIfNotExists=true, the component will automatically auto create a Cosmos container.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_PATH_CONTAINER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CLIENT_TELEMETRY_ENABLED_CONF = "camel.sink.endpoint.clientTelemetryEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CLIENT_TELEMETRY_ENABLED_DOC = "Sets the flag to enable client telemetry which will periodically collect database operations aggregation statistics, system information like cpu/memory and send it to cosmos monitoring service, which will be helpful during debugging. DEFAULT value is false indicating this is opt in feature, by default no telemetry collection.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CLIENT_TELEMETRY_ENABLED_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_CONF = "camel.sink.endpoint.connectionSharingAcrossClientsEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_DOC = "Enables connections sharing across multiple Cosmos Clients. The default is false. When you have multiple instances of Cosmos Client in the same JVM interacting to multiple Cosmos accounts, enabling this allows connection sharing in Direct mode if possible between instances of Cosmos Client. Please note, when setting this option, the connection configuration (e.g., socket timeout config, idle timeout config) of the first instantiated client will be used for all other client instances.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONSISTENCY_LEVEL_CONF = "camel.sink.endpoint.consistencyLevel";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONSISTENCY_LEVEL_DOC = "Sets the consistency levels supported for Azure Cosmos DB client operations in the Azure Cosmos DB service. The requested ConsistencyLevel must match or be weaker than that provisioned for the database account. Consistency levels by order of strength are STRONG, BOUNDED_STALENESS, SESSION and EVENTUAL. Refer to consistency level documentation for additional details: https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels One of: [Strong] [BoundedStaleness] [Session] [Eventual] [ConsistentPrefix]";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONSISTENCY_LEVEL_DEFAULT = "SESSION";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTAINER_PARTITION_KEY_PATH_CONF = "camel.sink.endpoint.containerPartitionKeyPath";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTAINER_PARTITION_KEY_PATH_DOC = "Sets the container partition key path.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTAINER_PARTITION_KEY_PATH_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTENT_RESPONSE_ON_WRITE_ENABLED_CONF = "camel.sink.endpoint.contentResponseOnWriteEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTENT_RESPONSE_ON_WRITE_ENABLED_DOC = "Sets the boolean to only return the headers and status code in Cosmos DB response in case of Create, Update and Delete operations on CosmosItem. In Consumer, it is enabled by default because of the ChangeFeed in the consumer that needs this flag to be enabled and thus is shouldn't be overridden. In Producer, it advised to disable it since it reduces the network overhead";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTENT_RESPONSE_ON_WRITE_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_COSMOS_ASYNC_CLIENT_CONF = "camel.sink.endpoint.cosmosAsyncClient";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_COSMOS_ASYNC_CLIENT_DOC = "Inject an external CosmosAsyncClient into the component which provides a client-side logical representation of the Azure Cosmos DB service. This asynchronous client is used to configure and execute requests against the service.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_COSMOS_ASYNC_CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_CONTAINER_IF_NOT_EXISTS_CONF = "camel.sink.endpoint.createContainerIfNotExists";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_CONTAINER_IF_NOT_EXISTS_DOC = "Sets if the component should create Cosmos container automatically in case it doesn't exist in Cosmos database";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_CONTAINER_IF_NOT_EXISTS_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_DATABASE_IF_NOT_EXISTS_CONF = "camel.sink.endpoint.createDatabaseIfNotExists";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_DATABASE_IF_NOT_EXISTS_DOC = "Sets if the component should create Cosmos database automatically in case it doesn't exist in Cosmos account";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_DATABASE_IF_NOT_EXISTS_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_DATABASE_ENDPOINT_CONF = "camel.sink.endpoint.databaseEndpoint";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_DATABASE_ENDPOINT_DOC = "Sets the Azure Cosmos database endpoint the component will connect to.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_DATABASE_ENDPOINT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_MULTIPLE_WRITE_REGIONS_ENABLED_CONF = "camel.sink.endpoint.multipleWriteRegionsEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_MULTIPLE_WRITE_REGIONS_ENABLED_DOC = "Sets the flag to enable writes on any regions for geo-replicated database accounts in the Azure Cosmos DB service. When the value of this property is true, the SDK will direct write operations to available writable regions of geo-replicated database account. Writable regions are ordered by PreferredRegions property. Setting the property value to true has no effect until EnableMultipleWriteRegions in DatabaseAccount is also set to true. DEFAULT value is true indicating that writes are directed to available writable regions of geo-replicated database account.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_MULTIPLE_WRITE_REGIONS_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_PREFERRED_REGIONS_CONF = "camel.sink.endpoint.preferredRegions";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_PREFERRED_REGIONS_DOC = "Sets the preferred regions for geo-replicated database accounts. For example, East US as the preferred region. When EnableEndpointDiscovery is true and PreferredRegions is non-empty, the SDK will prefer to use the regions in the container in the order they are specified to perform operations.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_PREFERRED_REGIONS_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_READ_REQUESTS_FALLBACK_ENABLED_CONF = "camel.sink.endpoint.readRequestsFallbackEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_READ_REQUESTS_FALLBACK_ENABLED_DOC = "Sets whether to allow for reads to go to multiple regions configured on an account of Azure Cosmos DB service. DEFAULT value is true. If this property is not set, the default is true for all Consistency Levels other than Bounded Staleness, The default is false for Bounded Staleness. 1. endpointDiscoveryEnabled is true 2. the Azure Cosmos DB account has more than one region";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_READ_REQUESTS_FALLBACK_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_THROUGHPUT_PROPERTIES_CONF = "camel.sink.endpoint.throughputProperties";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_THROUGHPUT_PROPERTIES_DOC = "Sets throughput of the resources in the Azure Cosmos DB service.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_THROUGHPUT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_ID_CONF = "camel.sink.endpoint.itemId";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_ID_DOC = "Sets the itemId in case needed for operation on item like delete, replace";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_ID_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_PARTITION_KEY_CONF = "camel.sink.endpoint.itemPartitionKey";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_PARTITION_KEY_DOC = "Sets partition key. Represents a partition key value in the Azure Cosmos DB database service. A partition key identifies the partition where the item is stored in.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_PARTITION_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_OPERATION_CONF = "camel.sink.endpoint.operation";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_OPERATION_DOC = "The CosmosDB operation that can be used with this component on the producer. One of: [listDatabases] [createDatabase] [queryDatabases] [deleteDatabase] [createContainer] [replaceDatabaseThroughput] [listContainers] [queryContainers] [deleteContainer] [replaceContainerThroughput] [createItem] [upsertItem] [deleteItem] [replaceItem] [readItem] [readAllItems] [queryItems]";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_OPERATION_DEFAULT = "listDatabases";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_CONF = "camel.sink.endpoint.query";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_DOC = "An SQL query to execute on a given resources. To learn more about Cosmos SQL API, check this link {link https://docs.microsoft.com/en-us/azure/cosmos-db/sql-query-getting-started}";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_REQUEST_OPTIONS_CONF = "camel.sink.endpoint.queryRequestOptions";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_REQUEST_OPTIONS_DOC = "Set additional QueryRequestOptions that can be used with queryItems, queryContainers, queryDatabases, listDatabases, listItems, listContainers operations";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_REQUEST_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ACCOUNT_KEY_CONF = "camel.sink.endpoint.accountKey";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ACCOUNT_KEY_DOC = "Sets either a master or readonly key used to perform authentication for accessing resource.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ACCOUNT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CLIENT_TELEMETRY_ENABLED_CONF = "camel.component.azure-cosmosdb.clientTelemetryEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CLIENT_TELEMETRY_ENABLED_DOC = "Sets the flag to enable client telemetry which will periodically collect database operations aggregation statistics, system information like cpu/memory and send it to cosmos monitoring service, which will be helpful during debugging. DEFAULT value is false indicating this is opt in feature, by default no telemetry collection.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CLIENT_TELEMETRY_ENABLED_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONFIGURATION_CONF = "camel.component.azure-cosmosdb.configuration";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONFIGURATION_DOC = "The component configurations";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_CONF = "camel.component.azure-cosmosdb.connectionSharingAcrossClientsEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_DOC = "Enables connections sharing across multiple Cosmos Clients. The default is false. When you have multiple instances of Cosmos Client in the same JVM interacting to multiple Cosmos accounts, enabling this allows connection sharing in Direct mode if possible between instances of Cosmos Client. Please note, when setting this option, the connection configuration (e.g., socket timeout config, idle timeout config) of the first instantiated client will be used for all other client instances.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONSISTENCY_LEVEL_CONF = "camel.component.azure-cosmosdb.consistencyLevel";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONSISTENCY_LEVEL_DOC = "Sets the consistency levels supported for Azure Cosmos DB client operations in the Azure Cosmos DB service. The requested ConsistencyLevel must match or be weaker than that provisioned for the database account. Consistency levels by order of strength are STRONG, BOUNDED_STALENESS, SESSION and EVENTUAL. Refer to consistency level documentation for additional details: https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels One of: [Strong] [BoundedStaleness] [Session] [Eventual] [ConsistentPrefix]";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONSISTENCY_LEVEL_DEFAULT = "SESSION";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTAINER_PARTITION_KEY_PATH_CONF = "camel.component.azure-cosmosdb.containerPartitionKeyPath";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTAINER_PARTITION_KEY_PATH_DOC = "Sets the container partition key path.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTAINER_PARTITION_KEY_PATH_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTENT_RESPONSE_ON_WRITE_ENABLED_CONF = "camel.component.azure-cosmosdb.contentResponseOnWriteEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTENT_RESPONSE_ON_WRITE_ENABLED_DOC = "Sets the boolean to only return the headers and status code in Cosmos DB response in case of Create, Update and Delete operations on CosmosItem. In Consumer, it is enabled by default because of the ChangeFeed in the consumer that needs this flag to be enabled and thus is shouldn't be overridden. In Producer, it advised to disable it since it reduces the network overhead";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTENT_RESPONSE_ON_WRITE_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_COSMOS_ASYNC_CLIENT_CONF = "camel.component.azure-cosmosdb.cosmosAsyncClient";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_COSMOS_ASYNC_CLIENT_DOC = "Inject an external CosmosAsyncClient into the component which provides a client-side logical representation of the Azure Cosmos DB service. This asynchronous client is used to configure and execute requests against the service.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_COSMOS_ASYNC_CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_CONTAINER_IF_NOT_EXISTS_CONF = "camel.component.azure-cosmosdb.createContainerIfNotExists";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_CONTAINER_IF_NOT_EXISTS_DOC = "Sets if the component should create Cosmos container automatically in case it doesn't exist in Cosmos database";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_CONTAINER_IF_NOT_EXISTS_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_DATABASE_IF_NOT_EXISTS_CONF = "camel.component.azure-cosmosdb.createDatabaseIfNotExists";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_DATABASE_IF_NOT_EXISTS_DOC = "Sets if the component should create Cosmos database automatically in case it doesn't exist in Cosmos account";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_DATABASE_IF_NOT_EXISTS_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_DATABASE_ENDPOINT_CONF = "camel.component.azure-cosmosdb.databaseEndpoint";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_DATABASE_ENDPOINT_DOC = "Sets the Azure Cosmos database endpoint the component will connect to.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_DATABASE_ENDPOINT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_MULTIPLE_WRITE_REGIONS_ENABLED_CONF = "camel.component.azure-cosmosdb.multipleWriteRegionsEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_MULTIPLE_WRITE_REGIONS_ENABLED_DOC = "Sets the flag to enable writes on any regions for geo-replicated database accounts in the Azure Cosmos DB service. When the value of this property is true, the SDK will direct write operations to available writable regions of geo-replicated database account. Writable regions are ordered by PreferredRegions property. Setting the property value to true has no effect until EnableMultipleWriteRegions in DatabaseAccount is also set to true. DEFAULT value is true indicating that writes are directed to available writable regions of geo-replicated database account.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_MULTIPLE_WRITE_REGIONS_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_PREFERRED_REGIONS_CONF = "camel.component.azure-cosmosdb.preferredRegions";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_PREFERRED_REGIONS_DOC = "Sets the preferred regions for geo-replicated database accounts. For example, East US as the preferred region. When EnableEndpointDiscovery is true and PreferredRegions is non-empty, the SDK will prefer to use the regions in the container in the order they are specified to perform operations.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_PREFERRED_REGIONS_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_READ_REQUESTS_FALLBACK_ENABLED_CONF = "camel.component.azure-cosmosdb.readRequestsFallbackEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_READ_REQUESTS_FALLBACK_ENABLED_DOC = "Sets whether to allow for reads to go to multiple regions configured on an account of Azure Cosmos DB service. DEFAULT value is true. If this property is not set, the default is true for all Consistency Levels other than Bounded Staleness, The default is false for Bounded Staleness. 1. endpointDiscoveryEnabled is true 2. the Azure Cosmos DB account has more than one region";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_READ_REQUESTS_FALLBACK_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_THROUGHPUT_PROPERTIES_CONF = "camel.component.azure-cosmosdb.throughputProperties";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_THROUGHPUT_PROPERTIES_DOC = "Sets throughput of the resources in the Azure Cosmos DB service.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_THROUGHPUT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_ID_CONF = "camel.component.azure-cosmosdb.itemId";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_ID_DOC = "Sets the itemId in case needed for operation on item like delete, replace";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_ID_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_PARTITION_KEY_CONF = "camel.component.azure-cosmosdb.itemPartitionKey";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_PARTITION_KEY_DOC = "Sets partition key. Represents a partition key value in the Azure Cosmos DB database service. A partition key identifies the partition where the item is stored in.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_PARTITION_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.azure-cosmosdb.lazyStartProducer";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_OPERATION_CONF = "camel.component.azure-cosmosdb.operation";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_OPERATION_DOC = "The CosmosDB operation that can be used with this component on the producer. One of: [listDatabases] [createDatabase] [queryDatabases] [deleteDatabase] [createContainer] [replaceDatabaseThroughput] [listContainers] [queryContainers] [deleteContainer] [replaceContainerThroughput] [createItem] [upsertItem] [deleteItem] [replaceItem] [readItem] [readAllItems] [queryItems]";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_OPERATION_DEFAULT = "listDatabases";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_CONF = "camel.component.azure-cosmosdb.query";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_DOC = "An SQL query to execute on a given resources. To learn more about Cosmos SQL API, check this link {link https://docs.microsoft.com/en-us/azure/cosmos-db/sql-query-getting-started}";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_REQUEST_OPTIONS_CONF = "camel.component.azure-cosmosdb.queryRequestOptions";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_REQUEST_OPTIONS_DOC = "Set additional QueryRequestOptions that can be used with queryItems, queryContainers, queryDatabases, listDatabases, listItems, listContainers operations";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_REQUEST_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.azure-cosmosdb.autowiredEnabled";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_AZURECOSMOSDB_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ACCOUNT_KEY_CONF = "camel.component.azure-cosmosdb.accountKey";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ACCOUNT_KEY_DOC = "Sets either a master or readonly key used to perform authentication for accessing resource.";
    public static final String CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ACCOUNT_KEY_DEFAULT = null;

    public CamelAzurecosmosdbSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAzurecosmosdbSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_AZURECOSMOSDB_PATH_DATABASE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_PATH_DATABASE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_PATH_DATABASE_NAME_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_PATH_CONTAINER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_PATH_CONTAINER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_PATH_CONTAINER_NAME_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CLIENT_TELEMETRY_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CLIENT_TELEMETRY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CLIENT_TELEMETRY_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONSISTENCY_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONSISTENCY_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONSISTENCY_LEVEL_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTAINER_PARTITION_KEY_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTAINER_PARTITION_KEY_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTAINER_PARTITION_KEY_PATH_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTENT_RESPONSE_ON_WRITE_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTENT_RESPONSE_ON_WRITE_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CONTENT_RESPONSE_ON_WRITE_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_COSMOS_ASYNC_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_COSMOS_ASYNC_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_COSMOS_ASYNC_CLIENT_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_CONTAINER_IF_NOT_EXISTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_CONTAINER_IF_NOT_EXISTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_CONTAINER_IF_NOT_EXISTS_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_DATABASE_IF_NOT_EXISTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_DATABASE_IF_NOT_EXISTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_CREATE_DATABASE_IF_NOT_EXISTS_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_DATABASE_ENDPOINT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_DATABASE_ENDPOINT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_DATABASE_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_MULTIPLE_WRITE_REGIONS_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_MULTIPLE_WRITE_REGIONS_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_MULTIPLE_WRITE_REGIONS_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_PREFERRED_REGIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_PREFERRED_REGIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_PREFERRED_REGIONS_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_READ_REQUESTS_FALLBACK_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_READ_REQUESTS_FALLBACK_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_READ_REQUESTS_FALLBACK_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_THROUGHPUT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_THROUGHPUT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_THROUGHPUT_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_ID_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_PARTITION_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_PARTITION_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ITEM_PARTITION_KEY_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_OPERATION_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_REQUEST_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_REQUEST_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_QUERY_REQUEST_OPTIONS_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ACCOUNT_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ACCOUNT_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AZURECOSMOSDB_ENDPOINT_ACCOUNT_KEY_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CLIENT_TELEMETRY_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CLIENT_TELEMETRY_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CLIENT_TELEMETRY_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONNECTION_SHARING_ACROSS_CLIENTS_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONSISTENCY_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONSISTENCY_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONSISTENCY_LEVEL_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTAINER_PARTITION_KEY_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTAINER_PARTITION_KEY_PATH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTAINER_PARTITION_KEY_PATH_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTENT_RESPONSE_ON_WRITE_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTENT_RESPONSE_ON_WRITE_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CONTENT_RESPONSE_ON_WRITE_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_COSMOS_ASYNC_CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_COSMOS_ASYNC_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_COSMOS_ASYNC_CLIENT_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_CONTAINER_IF_NOT_EXISTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_CONTAINER_IF_NOT_EXISTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_CONTAINER_IF_NOT_EXISTS_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_DATABASE_IF_NOT_EXISTS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_DATABASE_IF_NOT_EXISTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_CREATE_DATABASE_IF_NOT_EXISTS_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_DATABASE_ENDPOINT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_DATABASE_ENDPOINT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_DATABASE_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_MULTIPLE_WRITE_REGIONS_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_MULTIPLE_WRITE_REGIONS_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_MULTIPLE_WRITE_REGIONS_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_PREFERRED_REGIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_PREFERRED_REGIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_PREFERRED_REGIONS_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_READ_REQUESTS_FALLBACK_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_READ_REQUESTS_FALLBACK_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_READ_REQUESTS_FALLBACK_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_THROUGHPUT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_THROUGHPUT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_THROUGHPUT_PROPERTIES_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_ID_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_PARTITION_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_PARTITION_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ITEM_PARTITION_KEY_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_OPERATION_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_REQUEST_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_REQUEST_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_QUERY_REQUEST_OPTIONS_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ACCOUNT_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ACCOUNT_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AZURECOSMOSDB_COMPONENT_ACCOUNT_KEY_DOC);
        return conf;
    }
}