/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.netty.BufferedReactorNettyHttpResponse;
import com.azure.core.http.netty.ReactorNettyHttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

class NettyAsyncHttpClient
implements HttpClient {
    private final boolean disableBufferCopy;
    final reactor.netty.http.client.HttpClient nettyClient;

    NettyAsyncHttpClient() {
        this(reactor.netty.http.client.HttpClient.create(), false);
    }

    NettyAsyncHttpClient(reactor.netty.http.client.HttpClient nettyClient, boolean disableBufferCopy) {
        this.nettyClient = nettyClient;
        this.disableBufferCopy = disableBufferCopy;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        boolean eagerlyReadResponse = context.getData((Object)"azure-eagerly-read-response").orElse(false);
        return ((HttpClient.RequestSender)this.nettyClient.request(HttpMethod.valueOf((String)request.getHttpMethod().toString())).uri(request.getUrl().toString())).send(NettyAsyncHttpClient.bodySendDelegate(request)).responseConnection(NettyAsyncHttpClient.responseDelegate(request, this.disableBufferCopy, eagerlyReadResponse)).single();
    }

    private static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> bodySendDelegate(HttpRequest restRequest) {
        return (reactorNettyRequest, reactorNettyOutbound) -> {
            for (HttpHeader header : restRequest.getHeaders()) {
                if (header.getValue() == null) continue;
                reactorNettyRequest.header((CharSequence)header.getName(), (CharSequence)header.getValue());
            }
            if (restRequest.getBody() != null) {
                Flux nettyByteBufFlux = restRequest.getBody().map(Unpooled::wrappedBuffer);
                return reactorNettyOutbound.send((Publisher)nettyByteBufFlux);
            }
            return reactorNettyOutbound;
        };
    }

    private static BiFunction<HttpClientResponse, Connection, Publisher<HttpResponse>> responseDelegate(HttpRequest restRequest, boolean disableBufferCopy, boolean eagerlyReadResponse) {
        return (reactorNettyResponse, reactorNettyConnection) -> {
            if (eagerlyReadResponse) {
                Flux body = reactorNettyConnection.inbound().receive().asByteBuffer().doFinally(ignored -> NettyAsyncHttpClient.closeConnection(reactorNettyConnection));
                return FluxUtil.collectBytesInByteBufferStream((Flux)body).map(bytes -> new BufferedReactorNettyHttpResponse((HttpClientResponse)reactorNettyResponse, restRequest, (byte[])bytes));
            }
            return Mono.just((Object)((Object)new ReactorNettyHttpResponse((HttpClientResponse)reactorNettyResponse, (Connection)reactorNettyConnection, restRequest, disableBufferCopy)));
        };
    }

    static ByteBuffer deepCopyBuffer(ByteBuf byteBuf) {
        ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
        byteBuf.readBytes(buffer);
        buffer.rewind();
        return buffer;
    }

    static void closeConnection(Connection reactorNettyConnection) {
        if (!reactorNettyConnection.isDisposed()) {
            reactorNettyConnection.channel().eventLoop().execute(() -> ((Connection)reactorNettyConnection).dispose());
        }
    }
}

