/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;

public class CosmosStoredProcedureResponse
extends CosmosResponse<CosmosStoredProcedureProperties> {
    private final StoredProcedureResponse storedProcedureResponse;

    CosmosStoredProcedureResponse(ResourceResponse<StoredProcedure> response) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (!StringUtils.isEmpty(bodyAsString)) {
            super.setProperties(new CosmosStoredProcedureProperties(bodyAsString));
        }
        this.storedProcedureResponse = null;
    }

    CosmosStoredProcedureResponse(StoredProcedureResponse response) {
        super(new ResourceResponse<StoredProcedure>(response.getRxDocumentServiceResponse(), StoredProcedure.class));
        this.storedProcedureResponse = response;
    }

    @Override
    public CosmosStoredProcedureProperties getProperties() {
        return (CosmosStoredProcedureProperties)super.getProperties();
    }

    @Override
    public String getActivityId() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getActivityId();
        }
        return super.getActivityId();
    }

    @Override
    public String getSessionToken() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getSessionToken();
        }
        return super.getSessionToken();
    }

    @Override
    public int getStatusCode() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getStatusCode();
        }
        return super.getStatusCode();
    }

    @Override
    public double getRequestCharge() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getRequestCharge();
        }
        return super.getRequestCharge();
    }

    public String getResponseAsString() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getResponseAsString();
        }
        return null;
    }

    public String getScriptLog() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getScriptLog();
        }
        return null;
    }
}

