/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.models.ConflictResolutionMode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public final class ConflictResolutionPolicy {
    private JsonSerializable jsonSerializable;

    public static ConflictResolutionPolicy createLastWriterWinsPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.LAST_WRITER_WINS);
        return policy;
    }

    public static ConflictResolutionPolicy createLastWriterWinsPolicy(String conflictResolutionPath) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.LAST_WRITER_WINS);
        if (conflictResolutionPath != null) {
            policy.setConflictResolutionPath(conflictResolutionPath);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy(String conflictResolutionStoredProcFullPath) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.CUSTOM);
        if (conflictResolutionStoredProcFullPath != null) {
            policy.setConflictResolutionProcedure(conflictResolutionStoredProcFullPath);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy(String dbName, String containerName, String sprocName) {
        return ConflictResolutionPolicy.createCustomPolicy(ConflictResolutionPolicy.getFullPath(dbName, containerName, sprocName));
    }

    public static ConflictResolutionPolicy createCustomPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.CUSTOM);
        return policy;
    }

    ConflictResolutionPolicy() {
        this.jsonSerializable = new JsonSerializable();
    }

    ConflictResolutionPolicy(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    ConflictResolutionPolicy(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public ConflictResolutionMode getMode() {
        String strValue = this.jsonSerializable.getString("mode");
        if (!Strings.isNullOrEmpty(strValue)) {
            try {
                return ConflictResolutionMode.valueOf(Strings.fromCamelCaseToUpperCase(this.jsonSerializable.getString("mode")));
            }
            catch (IllegalArgumentException e) {
                this.jsonSerializable.getLogger().warn("INVALID ConflictResolutionMode getValue {}.", (Object)this.jsonSerializable.getString("mode"));
                return ConflictResolutionMode.INVALID;
            }
        }
        return ConflictResolutionMode.INVALID;
    }

    ConflictResolutionPolicy setMode(ConflictResolutionMode mode) {
        this.jsonSerializable.set("mode", mode.toString());
        return this;
    }

    public String getConflictResolutionPath() {
        return this.jsonSerializable.getString("conflictResolutionPath");
    }

    ConflictResolutionPolicy setConflictResolutionPath(String value) {
        this.jsonSerializable.set("conflictResolutionPath", value);
        return this;
    }

    public String getConflictResolutionProcedure() {
        return this.jsonSerializable.getString("conflictResolutionProcedure");
    }

    ConflictResolutionPolicy setConflictResolutionProcedure(String value) {
        this.jsonSerializable.set("conflictResolutionProcedure", value);
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }

    private static String getFullPath(String dbName, String containerName, String sprocName) {
        if (dbName == null) {
            throw new IllegalArgumentException("dbName cannot be null");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("containerName cannot be null");
        }
        if (sprocName == null) {
            throw new IllegalArgumentException("sprocName cannot be null");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("dbs");
        builder.append("/");
        builder.append(dbName);
        builder.append("/");
        builder.append("colls");
        builder.append("/");
        builder.append(containerName);
        builder.append("/");
        builder.append("sprocs");
        builder.append("/");
        builder.append(sprocName);
        return builder.toString();
    }
}

