/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.FeedResponse;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class Fetcher<T extends Resource> {
    private static final Logger logger = LoggerFactory.getLogger(Fetcher.class);
    private final BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc;
    private final Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc;
    private final boolean isChangeFeed;
    private volatile boolean shouldFetchMore;
    private volatile int maxItemCount;
    private volatile int top;
    private volatile String continuationToken;

    public Fetcher(BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, String continuationToken, boolean isChangeFeed, int top, int maxItemCount) {
        this.createRequestFunc = createRequestFunc;
        this.executeFunc = executeFunc;
        this.isChangeFeed = isChangeFeed;
        this.continuationToken = continuationToken;
        this.top = top;
        this.maxItemCount = top == -1 ? maxItemCount : Math.min(maxItemCount, top);
        this.shouldFetchMore = true;
    }

    public boolean shouldFetchMore() {
        return this.shouldFetchMore;
    }

    public Mono<FeedResponse<T>> nextPage() {
        RxDocumentServiceRequest request = this.createRequest();
        return this.nextPage(request);
    }

    private void updateState(FeedResponse<T> response) {
        this.continuationToken = response.getContinuationToken();
        if (this.top != -1) {
            this.top -= response.getResults().size();
            if (this.top < 0) {
                logger.warn("Azure Cosmos DB BackEnd Service returned more than requested {} items", (Object)this.maxItemCount);
                this.top = 0;
            }
            this.maxItemCount = Math.min(this.maxItemCount, this.top);
        }
        this.shouldFetchMore = this.shouldFetchMore && !StringUtils.isEmpty(this.continuationToken) && this.top != 0 && (!this.isChangeFeed || !BridgeInternal.noChanges(response));
        logger.debug("Fetcher state updated: isChangeFeed = {}, continuation token = {}, max item count = {}, should fetch more = {}", new Object[]{this.isChangeFeed, this.continuationToken, this.maxItemCount, this.shouldFetchMore});
    }

    private RxDocumentServiceRequest createRequest() {
        if (!this.shouldFetchMore) {
            logger.error("invalid state, trying to fetch more after completion");
            throw new IllegalStateException("INVALID state, trying to fetch more after completion");
        }
        return this.createRequestFunc.apply(this.continuationToken, this.maxItemCount);
    }

    private Mono<FeedResponse<T>> nextPage(RxDocumentServiceRequest request) {
        return this.executeFunc.apply(request).map(rsp -> {
            this.updateState((FeedResponse<T>)rsp);
            return rsp;
        });
    }
}

