/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.IRoutingMapProvider;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneException;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.feedranges.FeedRangeAsyncVisitor;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangeVisitor;
import com.azure.cosmos.implementation.feedranges.GenericFeedRangeVisitor;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.util.ArrayList;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class FeedRangePartitionKeyRangeImpl
extends FeedRangeInternal {
    private final String partitionKeyRangeId;
    private final PartitionKeyRangeIdentity partitionKeyRangeIdentity;

    public FeedRangePartitionKeyRangeImpl(String partitionKeyRangeId) {
        Preconditions.checkNotNull(partitionKeyRangeId, "Argument 'partitionKeyRangeId' must not be null");
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.partitionKeyRangeIdentity = new PartitionKeyRangeIdentity(partitionKeyRangeId);
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    public PartitionKeyRangeIdentity getPartitionKeyRangeIdentity() {
        return this.partitionKeyRangeIdentity;
    }

    @Override
    public void accept(FeedRangeVisitor visitor) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        visitor.visit(this);
    }

    @Override
    public <TInput> void accept(GenericFeedRangeVisitor<TInput> visitor, TInput input) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        visitor.visit(this, input);
    }

    @Override
    public <T> Mono<T> accept(FeedRangeAsyncVisitor<T> visitor) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        return visitor.visit(this);
    }

    @Override
    public Mono<UnmodifiableList<Range<String>>> getEffectiveRanges(IRoutingMapProvider routingMapProvider, String containerRid, PartitionKeyDefinition partitionKeyDefinition) {
        Mono getPkRangeTask = routingMapProvider.tryGetPartitionKeyRangeByIdAsync(null, containerRid, this.partitionKeyRangeId, false, null).flatMap(pkRangeHolder -> {
            if (pkRangeHolder.v == null) {
                return routingMapProvider.tryGetPartitionKeyRangeByIdAsync(null, containerRid, this.partitionKeyRangeId, true, null);
            }
            return Mono.just((Object)pkRangeHolder);
        }).flatMap(pkRangeHolder -> {
            if (pkRangeHolder.v == null) {
                return Mono.error((Throwable)((Object)new PartitionKeyRangeGoneException(String.format("The PartitionKeyRangeId: \"%s\" is not valid for the current container %s .", this.partitionKeyRangeId, containerRid))));
            }
            return Mono.just((Object)pkRangeHolder);
        });
        return getPkRangeTask.flatMap(pkRangeHolder -> {
            ArrayList<Range<String>> temp = new ArrayList<Range<String>>();
            if (pkRangeHolder != null) {
                temp.add(((PartitionKeyRange)pkRangeHolder.v).toRange());
            }
            return Mono.just((Object)((UnmodifiableList)UnmodifiableList.unmodifiableList(temp)));
        });
    }

    @Override
    public Mono<UnmodifiableList<String>> getPartitionKeyRanges(IRoutingMapProvider routingMapProvider, String containerRid, PartitionKeyDefinition partitionKeyDefinition) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(this.partitionKeyRangeId);
        return Mono.just((Object)((UnmodifiableList)UnmodifiableList.unmodifiableList(temp)));
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        if (this.partitionKeyRangeId != null) {
            BridgeInternal.setProperty(this, "PKRangeId", this.partitionKeyRangeId);
        }
    }

    @Override
    public String toString() {
        return this.partitionKeyRangeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedRangePartitionKeyRangeImpl that = (FeedRangePartitionKeyRangeImpl)o;
        return Objects.equals(this.partitionKeyRangeId, that.partitionKeyRangeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partitionKeyRangeId);
    }
}

