/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.feedranges.FeedRangeAsyncVisitor;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyRangeImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.Range;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Mono;

final class FeedRangePartitionKeyRangeExtractorImpl
extends FeedRangeAsyncVisitor<List<Range<String>>> {
    private final RxDocumentClientImpl client;
    private final String collectionLink;

    public FeedRangePartitionKeyRangeExtractorImpl(RxDocumentClientImpl client, String collectionLink) {
        Preconditions.checkNotNull(client, "'client' must not be null");
        Preconditions.checkNotNull(collectionLink, "'collectionLink' must not be null");
        this.client = client;
        this.collectionLink = collectionLink;
    }

    @Override
    public Mono<List<Range<String>>> visit(FeedRangePartitionKeyImpl feedRange) {
        RxPartitionKeyRangeCache partitionKeyRangeCache = this.client.getPartitionKeyRangeCache();
        Mono<ResourceResponse<DocumentCollection>> collectionResponseObservable = this.client.readCollection(this.collectionLink, null);
        return collectionResponseObservable.flatMap(collectionResponse -> {
            DocumentCollection collection = (DocumentCollection)collectionResponse.getResource();
            return feedRange.getEffectiveRanges(partitionKeyRangeCache, collection.getResourceId(), collection.getPartitionKey());
        });
    }

    @Override
    public Mono<List<Range<String>>> visit(FeedRangePartitionKeyRangeImpl feedRange) {
        RxPartitionKeyRangeCache partitionKeyRangeCache = this.client.getPartitionKeyRangeCache();
        Mono<ResourceResponse<DocumentCollection>> collectionResponseObservable = this.client.readCollection(this.collectionLink, null);
        return collectionResponseObservable.flatMap(collectionResponse -> {
            DocumentCollection collection = (DocumentCollection)collectionResponse.getResource();
            return feedRange.getEffectiveRanges(partitionKeyRangeCache, collection.getResourceId(), null);
        });
    }

    @Override
    public Mono<List<Range<String>>> visit(FeedRangeEpkImpl feedRange) {
        RxPartitionKeyRangeCache partitionKeyRangeCache = this.client.getPartitionKeyRangeCache();
        Mono<ResourceResponse<DocumentCollection>> collectionResponseObservable = this.client.readCollection(this.collectionLink, null);
        Mono valueHolderMono = collectionResponseObservable.flatMap(collectionResponse -> {
            DocumentCollection collection = (DocumentCollection)collectionResponse.getResource();
            return partitionKeyRangeCache.tryGetOverlappingRangesAsync(BridgeInternal.getMetaDataDiagnosticContext(null), collection.getResourceId(), feedRange.getRange(), false, null);
        });
        return valueHolderMono.map(FeedRangePartitionKeyRangeExtractorImpl::toFeedRanges);
    }

    private static UnmodifiableList<Range<String>> toFeedRanges(Utils.ValueHolder<List<PartitionKeyRange>> partitionKeyRangeListValueHolder) {
        List partitionKeyRangeList = (List)partitionKeyRangeListValueHolder.v;
        if (partitionKeyRangeList == null) {
            throw new IllegalStateException("PartitionKeyRange list cannot be null");
        }
        ArrayList feedRanges = new ArrayList();
        partitionKeyRangeList.forEach(pkRange -> feedRanges.add(pkRange.toRange()));
        return (UnmodifiableList)UnmodifiableList.unmodifiableList(feedRanges);
    }
}

