/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.implementation.IRoutingMapProvider;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.feedranges.FeedRangeAsyncVisitor;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyRangeImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeVisitor;
import com.azure.cosmos.implementation.feedranges.GenericFeedRangeVisitor;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class FeedRangeInternal
extends JsonSerializable
implements FeedRange {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedRangeInternal.class);

    public abstract void accept(FeedRangeVisitor var1);

    public abstract <TInput> void accept(GenericFeedRangeVisitor<TInput> var1, TInput var2);

    public abstract <T> Mono<T> accept(FeedRangeAsyncVisitor<T> var1);

    public static FeedRangeInternal convert(FeedRange feedRange) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null");
        if (feedRange instanceof FeedRangeInternal) {
            return (FeedRangeInternal)feedRange;
        }
        String json = feedRange.toJsonString();
        return FeedRangeInternal.fromJsonString(json);
    }

    public static FeedRangeInternal fromJsonString(String json) {
        FeedRangeInternal parsedRange = FeedRangeInternal.tryParse(json);
        if (parsedRange == null) {
            throw new IllegalArgumentException(String.format("The provided string '%s' does not represent any known format.", json));
        }
        return parsedRange;
    }

    public abstract Mono<UnmodifiableList<Range<String>>> getEffectiveRanges(IRoutingMapProvider var1, String var2, PartitionKeyDefinition var3);

    public abstract Mono<UnmodifiableList<String>> getPartitionKeyRanges(IRoutingMapProvider var1, String var2, PartitionKeyDefinition var3);

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
    }

    @Override
    public abstract String toString();

    @Override
    public String toJsonString() {
        return this.toJson();
    }

    public static FeedRangeInternal tryParse(String jsonString) {
        Preconditions.checkNotNull(jsonString, "Argument 'jsonString' must not be null");
        ObjectMapper mapper = Utils.getSimpleObjectMapper();
        try {
            JsonNode rootNode = mapper.readTree(jsonString);
            JsonNode rangeNode = rootNode.get("Range");
            if (rangeNode != null && rangeNode.isObject()) {
                Range<String> range = new Range<String>((ObjectNode)rangeNode);
                return new FeedRangeEpkImpl(range);
            }
            JsonNode pkNode = rootNode.get("PartitionKey");
            if (pkNode != null && pkNode.isArray()) {
                PartitionKeyInternal pk = (PartitionKeyInternal)mapper.convertValue((Object)pkNode, PartitionKeyInternal.class);
                return new FeedRangePartitionKeyImpl(pk);
            }
            JsonNode pkRangeIdNode = rootNode.get("PKRangeId");
            if (pkRangeIdNode != null && pkRangeIdNode.isTextual()) {
                return new FeedRangePartitionKeyRangeImpl(pkRangeIdNode.asText());
            }
            return null;
        }
        catch (IOException ioError) {
            LOGGER.debug("Failed to parse feed range JSON {}", (Object)jsonString, (Object)ioError);
            return null;
        }
    }
}

