/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.implementation.Integers;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuationVisitor;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.routing.Range;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

final class FeedRangeCompositeContinuationImpl
extends FeedRangeContinuation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedRangeCompositeContinuationImpl.class);
    private static final ShouldRetryResult NO_RETRY = ShouldRetryResult.noRetry();
    private static final ShouldRetryResult RETRY = ShouldRetryResult.retryAfter(Duration.ZERO);
    private final Queue<CompositeContinuationToken> compositeContinuationTokens = new LinkedList<CompositeContinuationToken>();
    private CompositeContinuationToken currentToken;
    private String initialNoResultsRange;

    public FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange, List<Range<String>> ranges) {
        this(containerRid, feedRange, ranges, null);
    }

    public FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange, List<Range<String>> ranges, String continuation) {
        this(containerRid, feedRange);
        Preconditions.checkNotNull(ranges, "'ranges' must not be null");
        if (ranges.size() == 0) {
            throw new IllegalArgumentException("'ranges' must not be empty");
        }
        for (Range<String> range : ranges) {
            this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(range.getMin(), range.getMax(), continuation));
        }
        this.currentToken = this.getCompositeContinuationTokens().peek();
    }

    private FeedRangeCompositeContinuationImpl(String containerRid, FeedRangeInternal feedRange) {
        super(containerRid, feedRange);
    }

    public Queue<CompositeContinuationToken> getCompositeContinuationTokens() {
        return this.compositeContinuationTokens;
    }

    public CompositeContinuationToken getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public FeedRangeInternal getFeedRange() {
        if (!(this.feedRange instanceof FeedRangeEpkImpl)) {
            return this.feedRange;
        }
        if (this.currentToken != null) {
            return new FeedRangeEpkImpl(this.currentToken.getRange());
        }
        return null;
    }

    @Override
    public String getContinuation() {
        CompositeContinuationToken tokenSnapshot = this.currentToken;
        if (tokenSnapshot == null) {
            return null;
        }
        return tokenSnapshot.getToken();
    }

    @Override
    public void replaceContinuation(String continuationToken) {
        CompositeContinuationToken continuationTokenSnapshot = this.currentToken;
        if (continuationTokenSnapshot == null) {
            return;
        }
        continuationTokenSnapshot.setToken(continuationToken);
        this.moveToNextToken();
    }

    @Override
    public boolean isDone() {
        return this.compositeContinuationTokens.size() == 0;
    }

    @Override
    public void validateContainer(String containerRid) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty(containerRid) || !containerRid.equals(this.getContainerRid())) {
            String message = String.format("The continuation was generated for container %s but current container is %s.", this.getContainerRid(), containerRid);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public ShouldRetryResult handleChangeFeedNotModified(RxDocumentServiceResponse response) {
        Preconditions.checkNotNull(response, "Argument 'response' must not be null");
        int statusCode = response.getStatusCode();
        if (statusCode >= 200 && statusCode <= 299) {
            this.initialNoResultsRange = null;
            return NO_RETRY;
        }
        if (statusCode == 304 && this.compositeContinuationTokens.size() > 1) {
            String eTag = response.getResponseHeaders().get("etag");
            if (this.initialNoResultsRange == null) {
                this.initialNoResultsRange = this.currentToken.getRange().getMin();
                this.replaceContinuation(eTag);
                return RETRY;
            }
            if (!this.initialNoResultsRange.equalsIgnoreCase(this.currentToken.getRange().getMin())) {
                this.replaceContinuation(eTag);
                return RETRY;
            }
        }
        return NO_RETRY;
    }

    @Override
    public Mono<ShouldRetryResult> handleSplit(RxDocumentClientImpl client, RxDocumentServiceResponse response) {
        boolean partitionSplit;
        Preconditions.checkNotNull(client, "Argument 'client' must not be null");
        Preconditions.checkNotNull(response, "Argument 'response' must not be null");
        Integer nSubStatus = 0;
        String valueSubStatus = response.getResponseHeaders().get("x-ms-substatus");
        if (!Strings.isNullOrEmpty(valueSubStatus)) {
            nSubStatus = Integers.tryParse(valueSubStatus);
        }
        boolean bl = partitionSplit = response.getStatusCode() == 410 && nSubStatus != null && (nSubStatus == 1002 || nSubStatus == 1007);
        if (!partitionSplit) {
            return Mono.just((Object)NO_RETRY);
        }
        RxPartitionKeyRangeCache partitionKeyRangeCache = client.getPartitionKeyRangeCache();
        Mono<Utils.ValueHolder<List<PartitionKeyRange>>> resolvedRangesTask = this.tryGetOverlappingRanges(partitionKeyRangeCache, this.currentToken.getRange().getMin(), this.currentToken.getRange().getMax(), true);
        return resolvedRangesTask.flatMap(resolvedRanges -> {
            if (resolvedRanges.v != null && ((List)resolvedRanges.v).size() > 0) {
                this.createChildRanges((List)resolvedRanges.v);
            }
            return Mono.just((Object)RETRY);
        });
    }

    @Override
    public void accept(FeedRangeContinuationVisitor visitor) {
        Preconditions.checkNotNull(visitor, "Argument 'visitor' must not be null");
        visitor.visit(this);
    }

    public static FeedRangeCompositeContinuationImpl createFromDeserializedTokens(String containerRid, FeedRangeInternal feedRange, List<CompositeContinuationToken> deserializedTokens) {
        FeedRangeCompositeContinuationImpl thisPtr = new FeedRangeCompositeContinuationImpl(containerRid, feedRange);
        Preconditions.checkNotNull(deserializedTokens, "'deserializedTokens' must not be null");
        if (deserializedTokens.size() == 0) {
            throw new IllegalArgumentException("'deserializedTokens' must not be empty");
        }
        thisPtr.compositeContinuationTokens.addAll(deserializedTokens);
        thisPtr.currentToken = thisPtr.getCompositeContinuationTokens().peek();
        return thisPtr;
    }

    public static FeedRangeContinuation parse(String jsonString) throws IOException {
        Preconditions.checkNotNull(jsonString, "Argument 'jsonString' must not be null");
        ObjectMapper mapper = Utils.getSimpleObjectMapper();
        return (FeedRangeContinuation)mapper.readValue(jsonString, FeedRangeCompositeContinuationImpl.class);
    }

    public String toString() {
        try {
            return Utils.getSimpleObjectMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable serialize the composite FeedRange continuation token into a JSON string", e);
        }
    }

    private void createChildRanges(List<PartitionKeyRange> keyRanges) {
        PartitionKeyRange firstRange = keyRanges.get(0);
        this.currentToken.setRange(new Range<String>(firstRange.getMinInclusive(), firstRange.getMaxExclusive(), true, false));
        CompositeContinuationToken continuationAsComposite = FeedRangeCompositeContinuationImpl.tryParseAsCompositeContinuationToken(this.currentToken.getToken());
        if (continuationAsComposite != null) {
            continuationAsComposite.setRange(this.currentToken.getRange());
            this.currentToken.setToken(continuationAsComposite.toJson());
            int size = keyRanges.size();
            for (int i = 1; i < size; ++i) {
                PartitionKeyRange keyRange = keyRanges.get(i);
                continuationAsComposite.setRange(keyRange.toRange());
                this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(keyRange.getMinInclusive(), keyRange.getMaxExclusive(), continuationAsComposite.toJson()));
            }
        } else {
            int size = keyRanges.size();
            for (int i = 1; i < size; ++i) {
                PartitionKeyRange keyRange = keyRanges.get(i);
                this.compositeContinuationTokens.add(FeedRangeCompositeContinuationImpl.createCompositeContinuationTokenForRange(keyRange.getMinInclusive(), keyRange.getMaxExclusive(), this.currentToken.getToken()));
            }
        }
    }

    private static CompositeContinuationToken createCompositeContinuationTokenForRange(String minInclusive, String maxExclusive, String token) {
        return new CompositeContinuationToken(token, new Range<String>(minInclusive, maxExclusive, true, false));
    }

    private void moveToNextToken() {
        CompositeContinuationToken recentToken = this.compositeContinuationTokens.poll();
        if (recentToken.getToken() != null) {
            this.compositeContinuationTokens.add(recentToken);
        }
        this.currentToken = this.compositeContinuationTokens.size() > 0 ? this.compositeContinuationTokens.peek() : null;
    }

    private Mono<Utils.ValueHolder<List<PartitionKeyRange>>> tryGetOverlappingRanges(RxPartitionKeyRangeCache partitionKeyRangeCache, String min, String max, Boolean forceRefresh) {
        return partitionKeyRangeCache.tryGetOverlappingRangesAsync(null, this.getContainerRid(), new Range<String>(min, max, false, true), forceRefresh, null);
    }

    private static CompositeContinuationToken tryParseAsCompositeContinuationToken(String providedContinuation) {
        try {
            ObjectMapper mapper = Utils.getSimpleObjectMapper();
            if (providedContinuation.trim().startsWith("[")) {
                List<CompositeContinuationToken> compositeContinuationTokens = Arrays.asList((CompositeContinuationToken[])mapper.readValue(providedContinuation, CompositeContinuationToken[].class));
                if (compositeContinuationTokens.size() > 0) {
                    return compositeContinuationTokens.get(0);
                }
                return null;
            }
            if (providedContinuation.trim().startsWith("{")) {
                return (CompositeContinuationToken)mapper.readValue(providedContinuation, CompositeContinuationToken.class);
            }
            return null;
        }
        catch (IOException ioError) {
            LOGGER.debug("Failed to parse as composite continuation token JSON ", (Object)providedContinuation, (Object)ioError);
            return null;
        }
    }
}

