/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.ChangeFeedOptions;
import com.azure.cosmos.implementation.changefeed.CancellationToken;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserver;
import com.azure.cosmos.implementation.changefeed.PartitionCheckpointer;
import com.azure.cosmos.implementation.changefeed.PartitionProcessor;
import com.azure.cosmos.implementation.changefeed.ProcessorSettings;
import com.azure.cosmos.implementation.changefeed.exceptions.LeaseLostException;
import com.azure.cosmos.implementation.changefeed.exceptions.PartitionNotFoundException;
import com.azure.cosmos.implementation.changefeed.exceptions.PartitionSplitException;
import com.azure.cosmos.implementation.changefeed.exceptions.TaskCancelledException;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedObserverContextImpl;
import com.azure.cosmos.implementation.changefeed.implementation.ExceptionClassifier;
import com.azure.cosmos.implementation.changefeed.implementation.StatusCodeErrorType;
import com.azure.cosmos.models.FeedResponse;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class PartitionProcessorImpl
implements PartitionProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PartitionProcessorImpl.class);
    private static final int DefaultMaxItemCount = 100;
    private final ProcessorSettings settings;
    private final PartitionCheckpointer checkpointer;
    private final ChangeFeedObserver observer;
    private final ChangeFeedOptions options;
    private final ChangeFeedContextClient documentClient;
    private volatile RuntimeException resultException;
    private volatile String lastContinuation;
    private volatile boolean isFirstQueryForChangeFeeds;

    public PartitionProcessorImpl(ChangeFeedObserver observer, ChangeFeedContextClient documentClient, ProcessorSettings settings, PartitionCheckpointer checkpointer) {
        this.observer = observer;
        this.documentClient = documentClient;
        this.settings = settings;
        this.checkpointer = checkpointer;
        this.options = new ChangeFeedOptions();
        this.options.setMaxItemCount(settings.getMaxItemCount());
        this.options.setPartitionKeyRangeId(settings.getPartitionKeyRangeId());
        this.options.setStartFromBeginning(settings.isStartFromBeginning());
        this.options.setRequestContinuation(settings.getStartContinuation());
        this.options.setStartDateTime(settings.getStartTime());
    }

    @Override
    public Mono<Void> run(CancellationToken cancellationToken) {
        this.lastContinuation = this.settings.getStartContinuation();
        this.isFirstQueryForChangeFeeds = true;
        this.options.setRequestContinuation(this.lastContinuation);
        return Flux.just((Object)this).flatMap(value -> {
            if (cancellationToken.isCancellationRequested()) {
                return Flux.empty();
            }
            if (this.isFirstQueryForChangeFeeds) {
                this.isFirstQueryForChangeFeeds = false;
                return Flux.just((Object)value);
            }
            Instant stopTimer = Instant.now().plus(this.settings.getFeedPollDelay());
            return Mono.just((Object)value).delayElement(Duration.ofMillis(100L)).repeat(() -> {
                Instant currentTime = Instant.now();
                return !cancellationToken.isCancellationRequested() && currentTime.isBefore(stopTimer);
            }).last();
        }).flatMap(value -> this.documentClient.createDocumentChangeFeedQuery(this.settings.getCollectionSelfLink(), this.options).limitRequest(1L)).flatMap(documentFeedResponse -> {
            if (cancellationToken.isCancellationRequested()) {
                return Flux.error((Throwable)new TaskCancelledException());
            }
            this.lastContinuation = documentFeedResponse.getContinuationToken();
            if (documentFeedResponse.getResults() != null && documentFeedResponse.getResults().size() > 0) {
                return this.dispatchChanges((FeedResponse<JsonNode>)documentFeedResponse).doOnError(throwable -> logger.debug("Exception was thrown from thread {}", (Object)Thread.currentThread().getId(), throwable)).doOnSuccess(Void2 -> {
                    this.options.setRequestContinuation(this.lastContinuation);
                    if (cancellationToken.isCancellationRequested()) {
                        throw new TaskCancelledException();
                    }
                });
            }
            this.options.setRequestContinuation(this.lastContinuation);
            if (cancellationToken.isCancellationRequested()) {
                return Flux.error((Throwable)new TaskCancelledException());
            }
            return Flux.empty();
        }).doOnComplete(() -> {
            if (this.options.getMaxItemCount().compareTo(this.settings.getMaxItemCount()) != 0) {
                this.options.setMaxItemCount(this.settings.getMaxItemCount());
            }
        }).onErrorResume(throwable -> {
            block16: {
                block15: {
                    if (!(throwable instanceof CosmosException)) break block15;
                    CosmosException clientException = (CosmosException)((Object)((Object)throwable));
                    logger.warn("CosmosException: partition {} from thread {}", new Object[]{this.settings.getPartitionKeyRangeId(), Thread.currentThread().getId(), clientException});
                    StatusCodeErrorType docDbError = ExceptionClassifier.classifyClientException(clientException);
                    switch (docDbError) {
                        case PARTITION_NOT_FOUND: {
                            this.resultException = new PartitionNotFoundException("Partition not found.", this.lastContinuation);
                            break;
                        }
                        case PARTITION_SPLIT: {
                            this.resultException = new PartitionSplitException("Partition split.", this.lastContinuation);
                            break;
                        }
                        case UNDEFINED: {
                            this.resultException = new RuntimeException((Throwable)((Object)clientException));
                            break;
                        }
                        case MAX_ITEM_COUNT_TOO_LARGE: {
                            if (this.options.getMaxItemCount() == null) {
                                this.options.setMaxItemCount(100);
                            } else if (this.options.getMaxItemCount() <= 1) {
                                logger.error("Cannot reduce maxItemCount further as it's already at {}", (Object)this.options.getMaxItemCount(), (Object)clientException);
                                this.resultException = new RuntimeException((Throwable)((Object)clientException));
                            }
                            this.options.setMaxItemCount(this.options.getMaxItemCount() / 2);
                            logger.warn("Reducing maxItemCount, new value: {}", (Object)this.options.getMaxItemCount());
                            return Flux.empty();
                        }
                        case TRANSIENT_ERROR: {
                            if (clientException.getRetryAfterDuration().toMillis() > 0L) {
                                Instant stopTimer = Instant.now().plus(clientException.getRetryAfterDuration().toMillis(), ChronoUnit.MILLIS);
                                return Mono.just((Object)clientException.getRetryAfterDuration().toMillis()).delayElement(Duration.ofMillis(100L)).repeat(() -> {
                                    Instant currentTime = Instant.now();
                                    return !cancellationToken.isCancellationRequested() && currentTime.isBefore(stopTimer);
                                }).flatMap(values -> Flux.empty());
                            }
                            break block16;
                        }
                        default: {
                            logger.error("Unrecognized Cosmos exception returned error code {}", (Object)docDbError, (Object)clientException);
                            this.resultException = new RuntimeException((Throwable)((Object)clientException));
                            break;
                        }
                    }
                    break block16;
                }
                if (throwable instanceof LeaseLostException) {
                    logger.info("LeaseLoseException with partition {} from thread {}", (Object)this.settings.getPartitionKeyRangeId(), (Object)Thread.currentThread().getId());
                    this.resultException = (LeaseLostException)throwable;
                } else if (throwable instanceof TaskCancelledException) {
                    logger.debug("Task cancelled exception: partition {} from {}", new Object[]{this.settings.getPartitionKeyRangeId(), Thread.currentThread().getId(), throwable});
                    this.resultException = (TaskCancelledException)throwable;
                } else {
                    logger.warn("Unexpected exception from thread {}", (Object)Thread.currentThread().getId(), throwable);
                    this.resultException = new RuntimeException((Throwable)throwable);
                }
            }
            return Flux.error((Throwable)throwable);
        }).repeat(() -> {
            if (cancellationToken.isCancellationRequested()) {
                this.resultException = new TaskCancelledException();
                return false;
            }
            return true;
        }).onErrorResume(throwable -> {
            if (this.resultException == null) {
                this.resultException = new RuntimeException((Throwable)throwable);
            }
            return Flux.empty();
        }).then();
    }

    @Override
    public RuntimeException getResultException() {
        return this.resultException;
    }

    private Mono<Void> dispatchChanges(FeedResponse<JsonNode> response) {
        ChangeFeedObserverContextImpl context = new ChangeFeedObserverContextImpl(this.settings.getPartitionKeyRangeId(), response, this.checkpointer);
        return this.observer.processChanges(context, response.getResults());
    }
}

