/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class QueryMetricsUtils {
    static final String Indent = " ";
    private static final int NANOS_TO_MILLIS = 1000000;
    private static final String BytesUnitString = "bytes";

    static HashMap<String, Double> parseDelimitedString(String delimitedString) {
        String[] headerAttributes;
        if (delimitedString == null) {
            throw new NullPointerException("delimitedString");
        }
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        boolean key = false;
        boolean value = true;
        for (String attribute : headerAttributes = StringUtils.split(delimitedString, ";")) {
            String[] attributeKeyValue = StringUtils.split(attribute, "=");
            if (attributeKeyValue.length != 2) {
                throw new NullPointerException("recieved a malformed delimited STRING");
            }
            String attributeKey = attributeKeyValue[0];
            double attributeValue = Double.parseDouble(attributeKeyValue[1]);
            metrics.put(attributeKey, attributeValue);
        }
        return metrics;
    }

    static Duration durationFromMetrics(HashMap<String, Double> metrics, String key) {
        Double durationInMilliseconds = metrics.get(key);
        if (durationInMilliseconds == null) {
            return Duration.ZERO;
        }
        long seconds = (long)(durationInMilliseconds / 1000.0);
        long nanoseconds = (long)((durationInMilliseconds - (double)seconds * 1000.0) * 1000000.0);
        return Duration.ofSeconds(seconds, nanoseconds);
    }

    static Duration getDurationFromMetrics(HashMap<String, Double> metrics, String key) {
        double timeSpanInMilliseconds = metrics.get(key);
        Duration timeSpanFromMetrics = QueryMetricsUtils.doubleMillisecondsToDuration(timeSpanInMilliseconds);
        return timeSpanFromMetrics;
    }

    private static Duration doubleMillisecondsToDuration(double timeSpanInMilliseconds) {
        long timeInNanoSeconds = (long)(timeSpanInMilliseconds * 1000000.0);
        return Duration.ofNanos(timeInNanoSeconds);
    }

    private static void appendToStringBuilder(StringBuilder stringBuilder, String property, String value, String units, int indentLevel) {
        String FormatString = "%-40s : %15s %-12s %s";
        stringBuilder.append(String.format(Locale.ROOT, "%-40s : %15s %-12s %s", StringUtils.repeat(Indent, indentLevel) + property, value, units, System.lineSeparator()));
    }

    static void appendBytesToStringBuilder(StringBuilder stringBuilder, String property, long bytes, int indentLevel) {
        String BytesFormatString = "%d";
        QueryMetricsUtils.appendToStringBuilder(stringBuilder, property, String.format("%d", bytes), BytesUnitString, indentLevel);
    }

    static void appendMillisecondsToStringBuilder(StringBuilder stringBuilder, String property, double milliseconds, int indentLevel) {
        String MillisecondsFormatString = "%f";
        String MillisecondsUnitString = "milliseconds";
        QueryMetricsUtils.appendToStringBuilder(stringBuilder, property, String.format("%f", milliseconds), "milliseconds", indentLevel);
    }

    static void appendNanosecondsToStringBuilder(StringBuilder stringBuilder, String property, double nanoSeconds, int indentLevel) {
        String MillisecondsFormatString = "%.2f";
        String MillisecondsUnitString = "milliseconds";
        QueryMetricsUtils.appendToStringBuilder(stringBuilder, property, String.format("%.2f", QueryMetricsUtils.nanosToMilliSeconds(nanoSeconds)), "milliseconds", indentLevel);
    }

    static double nanosToMilliSeconds(double nanos) {
        return nanos / 1000000.0;
    }

    static void appendHeaderToStringBuilder(StringBuilder stringBuilder, String headerTitle, int indentLevel) {
        String FormatString = "%s %s";
        stringBuilder.append(String.format(Locale.ROOT, "%s %s", String.join((CharSequence)StringUtils.repeat(Indent, indentLevel), new CharSequence[0]) + headerTitle, System.lineSeparator()));
    }

    static void appendRUToStringBuilder(StringBuilder stringBuilder, String property, double requestCharge, int indentLevel) {
        String RequestChargeFormatString = "%s";
        String RequestChargeUnitString = "RUs";
        QueryMetricsUtils.appendToStringBuilder(stringBuilder, property, String.format(Locale.ROOT, "%s", requestCharge), "RUs", indentLevel);
    }

    static void appendActivityIdsToStringBuilder(StringBuilder stringBuilder, String activityIdsLabel, List<String> activityIds, int indentLevel) {
        stringBuilder.append(activityIdsLabel);
        stringBuilder.append(System.lineSeparator());
        for (String activityId : activityIds) {
            stringBuilder.append(Indent);
            stringBuilder.append(activityId);
            stringBuilder.append(System.lineSeparator());
        }
    }

    static void appendPercentageToStringBuilder(StringBuilder stringBuilder, String property, double percentage, int indentLevel) {
        String PercentageFormatString = "%.2f";
        String PercentageUnitString = "%";
        QueryMetricsUtils.appendToStringBuilder(stringBuilder, property, String.format("%.2f", percentage * 100.0), "%", indentLevel);
    }

    static void appendCountToStringBuilder(StringBuilder stringBuilder, String property, long count, int indentLevel) {
        String CountFormatString = "%s";
        String CountUnitString = "";
        QueryMetricsUtils.appendToStringBuilder(stringBuilder, property, String.format("%s", count), "", indentLevel);
    }

    static void appendNewlineToStringBuilder(StringBuilder stringBuilder) {
        QueryMetricsUtils.appendHeaderToStringBuilder(stringBuilder, "", 0);
    }
}

