/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb.operations;

import com.azure.cosmos.models.ThroughputProperties;
import org.apache.camel.component.azure.cosmosdb.client.CosmosAsyncClientWrapper;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbClientOperations;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbContainerOperations;
import org.apache.camel.component.azure.cosmosdb.operations.CosmosDbDatabaseOperations;

public final class CosmosDbOperationsBuilder {
    private final CosmosAsyncClientWrapper clientWrapper;
    private String databaseName;
    private boolean createDatabaseIfNotExist;
    private String containerName;
    private String containerPartitionKeyPath;
    private boolean createContainerIfNotExist;
    private ThroughputProperties throughputProperties;

    private CosmosDbOperationsBuilder(CosmosAsyncClientWrapper clientWrapper) {
        this.clientWrapper = clientWrapper;
    }

    public static CosmosDbOperationsBuilder withClient(CosmosAsyncClientWrapper clientWrapper) {
        return new CosmosDbOperationsBuilder(clientWrapper);
    }

    public CosmosDbOperationsBuilder withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public CosmosDbOperationsBuilder withCreateDatabaseIfNotExist(boolean createDatabaseIfNotExist) {
        this.createDatabaseIfNotExist = createDatabaseIfNotExist;
        return this;
    }

    public CosmosDbOperationsBuilder withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public CosmosDbOperationsBuilder withContainerPartitionKeyPath(String containerPartitionKeyPath) {
        this.containerPartitionKeyPath = containerPartitionKeyPath;
        return this;
    }

    public CosmosDbOperationsBuilder withCreateContainerIfNotExist(boolean createContainerIfNotExist) {
        this.createContainerIfNotExist = createContainerIfNotExist;
        return this;
    }

    public CosmosDbOperationsBuilder withThroughputProperties(ThroughputProperties throughputProperties) {
        this.throughputProperties = throughputProperties;
        return this;
    }

    public CosmosDbDatabaseOperations buildDatabaseOperations() {
        if (this.createDatabaseIfNotExist) {
            return CosmosDbClientOperations.withClient(this.clientWrapper).createDatabaseIfNotExistAndGetDatabaseOperations(this.databaseName, this.throughputProperties);
        }
        return CosmosDbClientOperations.withClient(this.clientWrapper).getDatabaseOperations(this.databaseName);
    }

    public CosmosDbContainerOperations buildContainerOperations() {
        if (this.createContainerIfNotExist) {
            return this.buildDatabaseOperations().createContainerIfNotExistAndGetContainerOperations(this.containerName, this.containerPartitionKeyPath, this.throughputProperties);
        }
        return this.buildDatabaseOperations().getContainerOperations(this.containerName);
    }
}

