/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.queue.CloudQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.component.azure.queue.QueueServiceComponent;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class QueueServiceComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private QueueServiceConfiguration getOrCreateConfiguration(QueueServiceComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new QueueServiceConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        QueueServiceComponent target = (QueueServiceComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)QueueServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "azurequeueclient": 
            case "azureQueueClient": {
                this.getOrCreateConfiguration(target).setAzureQueueClient((CloudQueue)QueueServiceComponentConfigurer.property((CamelContext)camelContext, CloudQueue.class, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)QueueServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((QueueServiceConfiguration)QueueServiceComponentConfigurer.property((CamelContext)camelContext, QueueServiceConfiguration.class, (Object)value));
                return true;
            }
            case "credentials": {
                this.getOrCreateConfiguration(target).setCredentials((StorageCredentials)QueueServiceComponentConfigurer.property((CamelContext)camelContext, StorageCredentials.class, (Object)value));
                return true;
            }
            case "credentialsaccountkey": 
            case "credentialsAccountKey": {
                this.getOrCreateConfiguration(target).setCredentialsAccountKey((String)QueueServiceComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "credentialsaccountname": 
            case "credentialsAccountName": {
                this.getOrCreateConfiguration(target).setCredentialsAccountName((String)QueueServiceComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)QueueServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "messagetimetolive": 
            case "messageTimeToLive": {
                this.getOrCreateConfiguration(target).setMessageTimeToLive((Integer)QueueServiceComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "messagevisibilitydelay": 
            case "messageVisibilityDelay": {
                this.getOrCreateConfiguration(target).setMessageVisibilityDelay((Integer)QueueServiceComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((QueueServiceOperations)((Object)QueueServiceComponentConfigurer.property((CamelContext)camelContext, QueueServiceOperations.class, (Object)value)));
                return true;
            }
            case "queueprefix": 
            case "queuePrefix": {
                this.getOrCreateConfiguration(target).setQueuePrefix((String)QueueServiceComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "validateclienturi": 
            case "validateClientURI": {
                this.getOrCreateConfiguration(target).setValidateClientURI((Boolean)QueueServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "azurequeueclient": 
            case "azureQueueClient": {
                return CloudQueue.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return QueueServiceConfiguration.class;
            }
            case "credentials": {
                return StorageCredentials.class;
            }
            case "credentialsaccountkey": 
            case "credentialsAccountKey": {
                return String.class;
            }
            case "credentialsaccountname": 
            case "credentialsAccountName": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "messagetimetolive": 
            case "messageTimeToLive": {
                return Integer.TYPE;
            }
            case "messagevisibilitydelay": 
            case "messageVisibilityDelay": {
                return Integer.TYPE;
            }
            case "operation": {
                return QueueServiceOperations.class;
            }
            case "queueprefix": 
            case "queuePrefix": {
                return String.class;
            }
            case "validateclienturi": 
            case "validateClientURI": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        QueueServiceComponent target = (QueueServiceComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "azurequeueclient": 
            case "azureQueueClient": {
                return this.getOrCreateConfiguration(target).getAzureQueueClient();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "credentials": {
                return this.getOrCreateConfiguration(target).getCredentials();
            }
            case "credentialsaccountkey": 
            case "credentialsAccountKey": {
                return this.getOrCreateConfiguration(target).getCredentialsAccountKey();
            }
            case "credentialsaccountname": 
            case "credentialsAccountName": {
                return this.getOrCreateConfiguration(target).getCredentialsAccountName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "messagetimetolive": 
            case "messageTimeToLive": {
                return this.getOrCreateConfiguration(target).getMessageTimeToLive();
            }
            case "messagevisibilitydelay": 
            case "messageVisibilityDelay": {
                return this.getOrCreateConfiguration(target).getMessageVisibilityDelay();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "queueprefix": 
            case "queuePrefix": {
                return this.getOrCreateConfiguration(target).getQueuePrefix();
            }
            case "validateclienturi": 
            case "validateClientURI": {
                return this.getOrCreateConfiguration(target).isValidateClientURI();
            }
        }
        return null;
    }
}

