/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.function;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingBiConsumer;
import org.apache.camel.util.function.ThrowingConsumer;
import org.apache.camel.util.function.ThrowingFunction;
import org.apache.camel.util.function.ThrowingSupplier;

public final class ThrowingHelper {
    private ThrowingHelper() {
    }

    public static <V, T extends Throwable> Supplier<V> wrapAsSupplier(ThrowingSupplier<V, T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        };
    }

    public static <I, T extends Throwable> Consumer<I> wrapAsConsumer(ThrowingConsumer<I, T> consumer) {
        return in -> {
            try {
                consumer.accept(in);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        };
    }

    public static <I1, I2, T extends Throwable> BiConsumer<I1, I2> wrapAsBiConsumer(ThrowingBiConsumer<I1, I2, T> consumer) {
        return (i1, i2) -> {
            try {
                consumer.accept(i1, i2);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        };
    }

    public static <I, R, T extends Throwable> Function<I, R> wrapAsFunction(ThrowingFunction<I, R, T> function) {
        return in -> {
            try {
                return function.apply(in);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        };
    }

    public static <I, R, T extends Throwable> Optional<R> applyIfNotEmpty(I value, ThrowingFunction<I, R, T> function) throws T {
        if (ObjectHelper.isNotEmpty(value)) {
            return Optional.ofNullable(function.apply(value));
        }
        return Optional.empty();
    }

    public static <I, R, T extends Throwable> R applyIfNotEmpty(I value, ThrowingFunction<I, R, T> consumer, Supplier<R> orElse) throws T {
        if (ObjectHelper.isNotEmpty(value)) {
            return consumer.apply(value);
        }
        return orElse.get();
    }
}

