/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.reifier.language.ExpressionReifier;
import org.apache.camel.spi.NamespaceAware;

public class XPathExpressionReifier
extends ExpressionReifier<XPathExpression> {
    public XPathExpressionReifier(CamelContext camelContext, ExpressionDefinition definition) {
        super(camelContext, (XPathExpression)definition);
    }

    @Override
    protected void configureExpression(Expression expression) {
        this.bindProperties(expression);
        this.configureNamespaceAware(expression);
        super.configureExpression(expression);
    }

    @Override
    protected void configurePredicate(Predicate predicate) {
        this.bindProperties(predicate);
        this.configureNamespaceAware(predicate);
        super.configurePredicate(predicate);
    }

    protected void configureNamespaceAware(Object builder) {
        if (((XPathExpression)this.definition).getNamespaces() != null && builder instanceof NamespaceAware) {
            NamespaceAware namespaceAware = (NamespaceAware)builder;
            namespaceAware.setNamespaces(((XPathExpression)this.definition).getNamespaces());
        }
    }

    protected void bindProperties(Object target) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("documentType", this.or(((XPathExpression)this.definition).getDocumentType(), ((XPathExpression)this.definition).getDocumentTypeName()));
        properties.put("resultType", this.or(((XPathExpression)this.definition).getResultType(), ((XPathExpression)this.definition).getResultTypeName()));
        properties.put("useSaxon", ((XPathExpression)this.definition).getSaxon());
        properties.put("xPathFactory", this.or(((XPathExpression)this.definition).getXPathFactory(), this.asRef(((XPathExpression)this.definition).getFactoryRef())));
        properties.put("objectModelUri", ((XPathExpression)this.definition).getObjectModel());
        properties.put("threadSafety", ((XPathExpression)this.definition).getThreadSafety());
        properties.put("logNamespaces", ((XPathExpression)this.definition).getLogNamespaces());
        properties.put("headerName", ((XPathExpression)this.definition).getHeaderName());
        this.setProperties(target, properties);
    }
}

