/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAnonymous;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="azure-blob")
public class BlobServiceComponent
extends DefaultComponent {
    public static final String MISSING_BLOB_CREDENTIALS_EXCEPTION_MESSAGE = "One of azureBlobClient, credentials or both credentialsAccountName and credentialsAccountKey must be specified";
    @Metadata(label="advanced")
    private BlobServiceConfiguration configuration;

    public BlobServiceComponent() {
    }

    public BlobServiceComponent(CamelContext context) {
        super(context);
        this.configuration = new BlobServiceConfiguration();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BlobServiceConfiguration configuration = this.configuration != null ? this.configuration.copy() : new BlobServiceConfiguration();
        String[] parts = null;
        if (remaining != null) {
            parts = remaining.split("/");
        }
        if (parts == null || parts.length < 2) {
            throw new IllegalArgumentException("At least the account and container names must be specified.");
        }
        configuration.setAccountName(parts[0]);
        configuration.setContainerName(parts[1]);
        if (parts.length > 2) {
            StringBuilder sb = new StringBuilder();
            for (int i = 2; i < parts.length; ++i) {
                sb.append(parts[i]);
                if (i + 1 >= parts.length) continue;
                sb.append('/');
            }
            configuration.setBlobName(sb.toString());
        }
        BlobServiceEndpoint endpoint = new BlobServiceEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        this.checkCredentials(configuration);
        return endpoint;
    }

    public BlobServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BlobServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkCredentials(BlobServiceConfiguration cfg) {
        StorageCredentials creds;
        CloudBlob client = cfg.getAzureBlobClient();
        StorageCredentials storageCredentials = creds = client == null ? cfg.getAccountCredentials() : client.getServiceClient().getCredentials();
        if ((creds == null || creds instanceof StorageCredentialsAnonymous) && !cfg.isPublicForRead()) {
            throw new IllegalArgumentException(MISSING_BLOB_CREDENTIALS_EXCEPTION_MESSAGE);
        }
    }

    private void checkAndSetRegistryClient(BlobServiceConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(CloudBlob.class);
        if (clients.size() == 1) {
            configuration.setAzureBlobClient((CloudBlob)clients.stream().findFirst().get());
        }
    }
}

