/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnCompletionMode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.OnCompletionProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.RouteContext;

public class OnCompletionReifier
extends ProcessorReifier<OnCompletionDefinition> {
    public OnCompletionReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (OnCompletionDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Boolean routeScoped = ((OnCompletionDefinition)this.definition).getRouteScoped();
        if (routeScoped == null) {
            routeScoped = ((OnCompletionDefinition)this.definition).getParent() != null;
        }
        boolean isOnCompleteOnly = this.parseBoolean(((OnCompletionDefinition)this.definition).getOnCompleteOnly(), false);
        boolean isOnFailureOnly = this.parseBoolean(((OnCompletionDefinition)this.definition).getOnFailureOnly(), false);
        boolean isParallelProcessing = this.parseBoolean(((OnCompletionDefinition)this.definition).getParallelProcessing(), false);
        boolean original = this.parseBoolean(((OnCompletionDefinition)this.definition).getUseOriginalMessage(), false);
        if (isOnCompleteOnly && isOnFailureOnly) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        if (original) {
            this.routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
        }
        Processor childProcessor = this.createChildProcessor(true);
        CamelInternalProcessor internal = new CamelInternalProcessor(this.camelContext, childProcessor);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice(this.routeContext, this.camelContext));
        this.routeContext.setOnCompletion(this.getId(this.definition, this.routeContext), (Processor)internal);
        Predicate when = null;
        if (((OnCompletionDefinition)this.definition).getOnWhen() != null) {
            when = this.createPredicate(((OnCompletionDefinition)this.definition).getOnWhen().getExpression());
        }
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = this.getConfiguredExecutorService("OnCompletion", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        boolean afterConsumer = ((OnCompletionDefinition)this.definition).getMode() == null || this.parse(OnCompletionMode.class, ((OnCompletionDefinition)this.definition).getMode()) == OnCompletionMode.AfterConsumer;
        OnCompletionProcessor answer = new OnCompletionProcessor(this.camelContext, (Processor)internal, threadPool, shutdownThreadPool, isOnCompleteOnly, isOnFailureOnly, when, original, afterConsumer);
        return answer;
    }
}

