/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.TextTranslationJobFilter;
import software.amazon.awssdk.services.translate.model.TranslateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTextTranslationJobsRequest
extends TranslateRequest
implements ToCopyableBuilder<Builder, ListTextTranslationJobsRequest> {
    private static final SdkField<TextTranslationJobFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(ListTextTranslationJobsRequest.getter(ListTextTranslationJobsRequest::filter)).setter(ListTextTranslationJobsRequest.setter(Builder::filter)).constructor(TextTranslationJobFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTextTranslationJobsRequest.getter(ListTextTranslationJobsRequest::nextToken)).setter(ListTextTranslationJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTextTranslationJobsRequest.getter(ListTextTranslationJobsRequest::maxResults)).setter(ListTextTranslationJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final TextTranslationJobFilter filter;
    private final String nextToken;
    private final Integer maxResults;

    private ListTextTranslationJobsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public TextTranslationJobFilter filter() {
        return this.filter;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTextTranslationJobsRequest)) {
            return false;
        }
        ListTextTranslationJobsRequest other = (ListTextTranslationJobsRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListTextTranslationJobsRequest").add("Filter", (Object)this.filter()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTextTranslationJobsRequest, T> g) {
        return obj -> g.apply((ListTextTranslationJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateRequest.BuilderImpl
    implements Builder {
        private TextTranslationJobFilter filter;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTextTranslationJobsRequest model) {
            super(model);
            this.filter(model.filter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final TextTranslationJobFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(TextTranslationJobFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(TextTranslationJobFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTextTranslationJobsRequest build() {
            return new ListTextTranslationJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTextTranslationJobsRequest> {
        public Builder filter(TextTranslationJobFilter var1);

        default public Builder filter(Consumer<TextTranslationJobFilter.Builder> filter) {
            return this.filter((TextTranslationJobFilter)((TextTranslationJobFilter.Builder)TextTranslationJobFilter.builder().applyMutation(filter)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

