/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloneReceiptRuleSetRequest
extends SesRequest
implements ToCopyableBuilder<Builder, CloneReceiptRuleSetRequest> {
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetName").getter(CloneReceiptRuleSetRequest.getter(CloneReceiptRuleSetRequest::ruleSetName)).setter(CloneReceiptRuleSetRequest.setter(Builder::ruleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()}).build();
    private static final SdkField<String> ORIGINAL_RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalRuleSetName").getter(CloneReceiptRuleSetRequest.getter(CloneReceiptRuleSetRequest::originalRuleSetName)).setter(CloneReceiptRuleSetRequest.setter(Builder::originalRuleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalRuleSetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_NAME_FIELD, ORIGINAL_RULE_SET_NAME_FIELD));
    private final String ruleSetName;
    private final String originalRuleSetName;

    private CloneReceiptRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.originalRuleSetName = builder.originalRuleSetName;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String originalRuleSetName() {
        return this.originalRuleSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalRuleSetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloneReceiptRuleSetRequest)) {
            return false;
        }
        CloneReceiptRuleSetRequest other = (CloneReceiptRuleSetRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.originalRuleSetName(), other.originalRuleSetName());
    }

    public String toString() {
        return ToString.builder((String)"CloneReceiptRuleSetRequest").add("RuleSetName", (Object)this.ruleSetName()).add("OriginalRuleSetName", (Object)this.originalRuleSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "OriginalRuleSetName": {
                return Optional.ofNullable(clazz.cast(this.originalRuleSetName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloneReceiptRuleSetRequest, T> g) {
        return obj -> g.apply((CloneReceiptRuleSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String originalRuleSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloneReceiptRuleSetRequest model) {
            super(model);
            this.ruleSetName(model.ruleSetName);
            this.originalRuleSetName(model.originalRuleSetName);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getOriginalRuleSetName() {
            return this.originalRuleSetName;
        }

        @Override
        public final Builder originalRuleSetName(String originalRuleSetName) {
            this.originalRuleSetName = originalRuleSetName;
            return this;
        }

        public final void setOriginalRuleSetName(String originalRuleSetName) {
            this.originalRuleSetName = originalRuleSetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CloneReceiptRuleSetRequest build() {
            return new CloneReceiptRuleSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CloneReceiptRuleSetRequest> {
        public Builder ruleSetName(String var1);

        public Builder originalRuleSetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

